% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_barcode_start.R
\name{check_barcode_start_position}
\alias{check_barcode_start_position}
\title{Check Valid Barcode Start Position}
\usage{
check_barcode_start_position(
  fastq,
  barcode_file,
  barcode_file_realname,
  bstart,
  blength,
  search_lines,
  threshold
)
}
\arguments{
\item{fastq}{file containing reads}

\item{barcode_file}{csv file}

\item{barcode_file_realname}{the real name of the csv file}

\item{bstart}{the start position for barcodes in the given reads}

\item{blength}{length of each barcode}

\item{search_lines}{the number of fastq lines to use for the check}

\item{threshold}{the minimum percentage of found barcodes to accept for the
program to continue}
}
\value{
Boolean; TRUE if program can continue execution, FALSE otherwise.
}
\description{
Checks to see if the given barcode start position (\code{bstart})
is valid for the fastq file. If the found barcode percentage is less than
the given \code{threshold}, a new barcode start position is searched for by
checking every position from the start of each read to 10 bases after the \code{bstart}
}
