% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_sample_qc.R
\docType{data}
\name{cell_barcode_matching}
\alias{cell_barcode_matching}
\title{cell barcode demultiplex statistics for a small sample scRNA-seq 
dataset to demonstrate capabilities of scPipe}
\format{
a data.frame instance, one row per cell.
}
\source{
Christin Biben (WEHI). She FACS sorted cells from several immune
cell types including B cells, granulocyte and some early progenitors.
}
\value{
NULL, but makes a data frame with cell barcode demultiplex statistics
}
\description{
This data.frame contains cell barcode demultiplex statistics 
with several rows:\itemize{
\item{barcode_unmatch_ambiguous_mapping} is the number of reads that do not
match any barcode, but aligned to the genome and mapped to multiple 
features.
\item{barcode_unmatch_mapped_to_intron} is the number of reads that do
not match any barcode, but aligned to the genome and mapped to intron.
\item{barcode_match} is the number of reads that match the cell barcodes
\item{barcode_unmatch_unaligned} is the number of reads that do not 
match any barcode, and not aligned to the genome
\item{barcode_unmatch_aligned} is the number of reads that do not 
match any barcode, but aligned to the genome and do not mapped to any 
feature
\item{barcode_unmatch_mapped_to_exon} is the number of reads that do not
match any barcode, but aligned to the genome and mapped to the exon
}
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts =as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication

demultiplex_info(sce)

}
\author{
Luyi Tian
}
