% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anno_import.R
\name{anno_import}
\alias{anno_import}
\title{Import gene annotation}
\usage{
anno_import(filename)
}
\arguments{
\item{filename}{The name of the annotation gff3 or gtf file. File can be
gzipped.}
}
\value{
data.frame containing exon information in SAF format
}
\description{
Because of the variations in data format depending on annotation
  source, this function has only been tested with human annotation from
  ENSEMBL, RefSeq and Gencode. If it behaves unexpectedly with any annotation
  please submit an issue at www.github.com/LuyiTian/scPipe with details.
}
\details{
Imports and GFF3 or GTF gene annotation file and transforms it into a SAF
formatted data.frame. SAF described at
http://bioinf.wehi.edu.au/featureCounts/. SAF contains positions for exons,
strand and the GeneID they are associated with.
}
\examples{
ens_chrY <- anno_import(system.file("extdata", "ensembl_hg38_chrY.gtf.gz", package = "scPipe"))

}
