% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plots.R
\name{scmet_plot_mean_var}
\alias{scmet_plot_mean_var}
\title{Plotting mean-variability relationship}
\usage{
scmet_plot_mean_var(
  obj,
  y = "gamma",
  task = NULL,
  show_fit = TRUE,
  title = NULL,
  nfeatures = NULL,
  n = 80
)
}
\arguments{
\item{obj}{The scMET object after calling the \code{\link{scmet_hvf_lvf}}
function.}

\item{y}{The parameter to plot on the y-axis. Values can be \code{gamma} (default)
or \code{epsilon}.}

\item{task}{If NULL (default) the mean-variability relationship is plotted.
If set to "hvf" or "lvf", points are coloured according the HVF/LVF
analysis task.}

\item{show_fit}{Logical, whether to show the fitted mean-overdispersion
trend. Applicable only when \code{y = gamma} and \code{task = NULL}.}

\item{title}{Optional title, default NULL.}

\item{nfeatures}{Optional parameter, denoting a subset of number of features
to plot. Mostly to reduce over-plotting. When \verb{task = hvf or lvf}, the
subsampling is performed on the features that are not called as HVF or LVF
(i.e. not interesting features).}

\item{n}{Optional integer denoting the number of grid points to colour them
by density. Used by \code{\link[MASS]{kde2d}} function. Used only when
\code{task = NULL}.}
}
\value{
A ggplot2 object.
}
\description{
Function for plotting mean methylation on x-axis and variability
on y-axis (either overdispersion or residual overdispersion). If HVF/LVF
analysis is performed, points will be also coloured accordingly.
}
\examples{
# Fit scMET
obj <- scmet(Y = scmet_dt$Y, X = scmet_dt$X, L = 4, iter = 100)
scmet_plot_mean_var(obj = obj, y = "gamma")

}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_differential}},
\code{\link{scmet_hvf_lvf}}, \code{\link{scmet_plot_vf_tail_prob}},
\code{\link{scmet_plot_efdr_efnr_grid}}, \code{\link{scmet_plot_volcano}},
\code{\link{scmet_plot_ma}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
