% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plots.R
\name{scmet_plot_estimated_vs_true}
\alias{scmet_plot_estimated_vs_true}
\title{Plot true versus inferred parameter estimated.}
\usage{
scmet_plot_estimated_vs_true(
  obj,
  sim_dt,
  param = "mu",
  mle_fit = NULL,
  diff_feat_idx = NULL,
  hpd_thresh = 0.8,
  title = NULL,
  nfeatures = NULL
)
}
\arguments{
\item{obj}{The scMET object after calling the \code{\link{scmet}} function.}

\item{sim_dt}{The simulated data object. E.g. after calling the
\code{\link{scmet_simulate}} function.}

\item{param}{The parameter to plot posterior estimates, either "mu" or
"gamma".}

\item{mle_fit}{A three column matrix of beta-binomial maximum likelihood
estimates. First column feature name, second column mean methylation and
third column overdispersion estimates. Number of features should match the
ones used by scMET.}

\item{diff_feat_idx}{Vector with locations of features that were simulated to
be differentially variable or methylated. This is stored in the object
after calling the \code{\link{scmet_simulate_diff}} function.}

\item{hpd_thresh}{The high posterior density threshold, as computed by the
\code{\link[coda]{HPDinterval}} function.}

\item{title}{Optional title, default NULL.}

\item{nfeatures}{Optional parameter, denoting a subset of number of features
to plot. Mostly to reduce over-plotting.}
}
\value{
A ggplot2 object.
}
\description{
Function for plotting true on x-axis and inferred parameter
estimates on y-axis (either mean methylation or overdispersion). Along with
posterior medians, the 80 high posterior density is shown as error bars.
Wehn MLE estimates are provided, a plot showing the shrinkage introduced by
scMET is shown as arrows.
}
\examples{
# Fit scMET
obj <- scmet(Y = scmet_dt$Y, X = scmet_dt$X, L = 4, iter = 100)
scmet_plot_estimated_vs_true(obj = obj, sim_dt = scmet_dt, param = "mu")

# BB MLE fit to compare with scMET
mle_fit <- scmet_dt$Y[, bb_mle(cbind(total_reads, met_reads))
[c("mu", "gamma")], by = c("Feature")]
scmet_plot_estimated_vs_true(obj = obj, sim_dt = scmet_dt, param = "mu",
mle_fit = mle_fit)

}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_simulate_diff}},
\code{\link{scmet_simulate}}, \code{\link{scmet_plot_mean_var}},
\code{\link{scmet_plot_vf_tail_prob}},
\code{\link{scmet_plot_efdr_efnr_grid}}, \code{\link{scmet_plot_volcano}},
\code{\link{scmet_plot_ma}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
