% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmet_hvf_lvf.R
\name{scmet_hvf}
\alias{scmet_hvf}
\alias{detect_hvf_lvf}
\alias{detect_hvf}
\alias{scmet_lvf}
\alias{scmet_hvf_lvf}
\alias{detect_lvf}
\title{Detect highly (or lowly) variable features with scMET}
\usage{
scmet_hvf(
  scmet_obj,
  delta_e = 0.9,
  delta_g = NULL,
  evidence_thresh = 0.8,
  efdr = 0.1
)

scmet_lvf(
  scmet_obj,
  delta_e = 0.1,
  delta_g = NULL,
  evidence_thresh = 0.8,
  efdr = 0.1
)
}
\arguments{
\item{scmet_obj}{The scMET posterior object after performing inference, i.e.
after calling \code{scmet} function.}

\item{delta_e}{Percentile threshold for residual overdispersion to detect
variable features (between 0 and 1). Default: 0.9 for HVF and 0.1 for LVF
(top 10\%). NOTE: This parameter should be used when correcting for
mean-dispersion relationship.}

\item{delta_g}{Overdispersion contribution threshold (between 0 and 1).}

\item{evidence_thresh}{Optional parameter. Posterior evidence probability
threshold parameter \verb{alpha_\{H\}} (between 0.6 and 1).}

\item{efdr}{Target for expected false discovery rate related to HVF/LVF
detection (default = 0.1).}
}
\value{
The scMET posterior object with an additional element named \code{hvf} or
\code{lvf} according to the analysis performed. This is a list object containing
the following elements: \itemize{ \item{ \code{summary}: A data.frame
containing HVF or LVF analysis output information per feature, including
posterior medians for \code{mu}, \code{gamma}, and \code{epsilon}. The \code{tail_prob} column
contains the posterior tail probability of a feature being called as HVF or
LVF. The logical \code{is_variable} column informs whether the feature is called
as variable or not.} \item{ \code{evidence_thresh}: The optimal evidence
threshold. } \item{ \code{efdr}: The EFDR value.} \item{ \code{efnr}: The
EFNR value. } \item{\code{efdr_grid}: The EFDR values for the grid search.}
\item{\code{efnr_grid}: The EFNR values for the grid search.}
\item{\code{evidence_thresh_grid}: The grid where we searched for optimal
evidence threshold.} }
}
\description{
Function for calling features as highly (or lowly) variable
within a datasert or cell population. This can be thought as a feature
selection step, where the highly variable features (HVF) can be used for
diverse downstream tasks, such as clustering or visualisation. Two
approaches for identifying HVFs (or LVFs): (1) If we correct for
mean-dispersion relationship, then we work directly on residual dispersions
\code{epsilon}, and define a percentile threshold \code{delta_e}. This is the
preferred option since the residual overdispersion is not confounded by
mean methylation levels. (2) Work directly with the overdispersion
parameter \code{gamma} and define an overdispersion contribution threshold
\code{delta_g}, above (below) of which we call HVFs (LVFs).
}
\examples{
# Fit scMET
obj <- scmet(Y = scmet_dt$Y, X = scmet_dt$X, L = 4, iter = 100)

# Run HVF analysis
obj <- scmet_hvf(scmet_obj = obj)

# Run LVF analysis
obj <- scmet_lvf(scmet_obj = obj)

}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_differential}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
