% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmet.R
\name{scmet}
\alias{scmet}
\alias{scMET}
\alias{scmet_vb}
\alias{scmet_mcmc}
\title{Perform inference with scMET}
\usage{
scmet(
  Y,
  X = NULL,
  L = 4,
  use_mcmc = FALSE,
  use_eb = TRUE,
  iter = 5000,
  algorithm = "meanfield",
  output_samples = 2000,
  chains = 4,
  m_wmu = rep(0, NCOL(X)),
  s_wmu = 2,
  s_mu = 1.5,
  m_wgamma = rep(0, L),
  s_wgamma = 2,
  a_sgamma = 2,
  b_sgamma = 3,
  rbf_c = 1,
  init_using_eb = TRUE,
  tol_rel_obj = 1e-04,
  n_cores = 2,
  lambda = 4,
  seed = sample.int(.Machine$integer.max, 1),
  ...
)
}
\arguments{
\item{Y}{Observed data (methylated reads and total reads) for each feature
and cell, in a long format \code{\link{data.table}}. That is it should have
4 named columns: (Feature, Cell, total_reads, met_reads).}

\item{X}{Covariates which might explain variability in mean (methylation). If
X = NULL, then we do not perform any correction on the mean estimates. NOTE
that if X is provided, \code{rownames} of X should be the unique feature names
in Y. If the dimensions or all feature names do not match, an error will
be thrown.}

\item{L}{Total number of basis function to fit the mean-overdispersion trend.
For L = 1, this reduces to a model that does not correct for the
mean-overdispersion relationship.}

\item{use_mcmc}{Logical, whether to use the MCMC implementation for posterior
inference. If FALSE, we run the VB implementation (default). For small
datasets, we recommend using MCMC implementation since it is more stable.}

\item{use_eb}{Logical, whether to use 'Empirical Bayes' for parameter
initialization. If \code{TRUE} (default), it will intialise the \code{m_wmu} and
\code{m_wgamma} parameters below.}

\item{iter}{Total number of iterations, either MCMC or VB algorithm. NOTE:
The STAN implementation of VB relies on black-box variational inference
and potentially with relatively small sample sizes sometimes tends to
'search' around the local/global minima. We've seen that with larger sample
sizes (thousands of cells), it tends to converge much faster, e.g. around
2-3k iterations.}

\item{algorithm}{Stan algorithm to be used by Stan. If MCMC: Possible values
are: "NUTS", "HMC". If VB: Possible values are: "meanfield" and "fullrank".}

\item{output_samples}{If VB algorithm, the number of posterior samples to
draw and save.}

\item{chains}{Total number of chains.}

\item{m_wmu}{Prior mean of regression coefficients for covariates X.}

\item{s_wmu}{Prior standard deviation of regression coefficients for
covariates X.}

\item{s_mu}{Prior standard deviation for mean parameter \code{mu}.}

\item{m_wgamma}{Prior mean of regression coefficients of the basis functions.}

\item{s_wgamma}{Prior standard deviation of regression coefficients of the
basis functions.}

\item{a_sgamma}{Gamma prior (shape) for standard deviation for dispersion
parameter \code{gamma}.}

\item{b_sgamma}{Gamma prior (rate) for standard deviation for dispersion
parameter \code{gamma}.}

\item{rbf_c}{Scale parameter for empirically computing the variance of the
RBFs.}

\item{init_using_eb}{Logical, initial values of parameters for STAN posterior
inference. Preferably this should be set always to TRUE, to lower the
chances of VB/MCMC initialisations being far away from posterior mass.}

\item{tol_rel_obj}{If VB algorithm, the convergence tolerance on the relative
norm of the objective.}

\item{n_cores}{Total number of cores.}

\item{lambda}{The penalty term to fit the RBF coefficients for the
mean-overdispersion trend when initialising hyper-parameter with EB.}

\item{seed}{The seed for random number generation.}

\item{...}{Additional parameters passed to \code{Stan} fitting functions.}
}
\value{
An object of class \code{scmet_mcmc} or \code{scmet_vb} with the
following elements: \itemize{ \item{ \code{posterior}: A list of matrices
containing the samples from the posterior. Each matrix corresponds to a
different parameter returned from scMET.} \item{ \code{Y}: The observed
data Y. } \item{ \code{feature_names}: A vector of feature names.} \item{
\code{theta_priors}: A list with all prior parameter values, for
reproducibility purposes. } \item{\code{opts}: A list of all additional
parameters when running scMET. For reproducibility purposes.}}
}
\description{
Compute posterior of scMET model. This is the main function
which infers model parameters and corrects for the mean-overdispersion
relationship. The most important parameters the user should focus are \code{X},
\code{L}, \code{user_mcmc} and \code{iter}. Advanced users may want to optimise the model
by changing the prior parameters. For small datasets, we recommend using
MCMC implementation of scMET since it is more stable.
}
\examples{
# Fit scMET (in practice 'iter' should be much larger)
obj <- scmet(Y = scmet_dt$Y, X = scmet_dt$X, L = 4, iter = 300)

}
\seealso{
\code{\link{scmet_differential}}, \code{\link{scmet_hvf_lvf}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
