% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{scHOT_stripOutput}
\alias{scHOT_stripOutput}
\title{scHOT_stripOutput}
\usage{
scHOT_stripOutput(scHOT, force = TRUE, store = FALSE, file_name = NULL)
}
\arguments{
\item{scHOT}{A scHOT object}

\item{force}{A logical indicates whther forcing stripping the scHOT output}

\item{store}{A logical flag on whether the scHOT should be stored as .rds file}

\item{file_name}{A string indicates the file name of the scHOT will be stored}
}
\value{
A scHOT object with scHOT_output striped
}
\description{
Strip the scHOT output
}
\examples{
data(MOB_subset)
sce_MOB_subset <- MOB_subset$sce_MOB_subset
scHOT_spatial <- scHOT_buildFromSCE(sce_MOB_subset,
                                     assayName = "logcounts",
                                    positionType = "spatial",
                                     positionColData = c("x", "y"))

scHOT_spatial <- scHOT_stripOutput(scHOT_spatial)



}
