% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{scHOT_setPermutationScaffold}
\alias{scHOT_setPermutationScaffold}
\title{scHOT_setPermutationScaffold}
\usage{
scHOT_setPermutationScaffold(
  scHOT,
  numberPermutations = 1000,
  numberScaffold = 100,
  storePermutations = TRUE
)
}
\arguments{
\item{scHOT}{A scHOT object}

\item{numberPermutations}{The number of permutations, set as 1000 by default}

\item{numberScaffold}{The number of scaffold, set as 100 by default, minimum 6.
if you want all combinations to do permutations then set,
numberScaffold much higher than the testingScaffold}

\item{storePermutations}{a logical flag on whether
Permutations should be stored, or discarded once used}
}
\value{
A scHOT object with storePermutations in slot scHOT_output saved
}
\description{
Set permutation scaffold
}
\examples{
 data(MOB_subset)
 sce_MOB_subset <- MOB_subset$sce_MOB_subset
 scHOT_spatial <- scHOT_buildFromSCE(sce_MOB_subset,
                                     assayName = "logcounts",
                                    positionType = "spatial",
                                     positionColData = c("x", "y"))
pairs <- matrix(c("Arrb1", "Mtor", "Dnm1l", "Gucy1b3"), ncol = 2, byrow = TRUE)
rownames(pairs) <- apply(pairs,1,paste0,collapse = "_")
scHOT_spatial <- scHOT_addTestingScaffold(scHOT_spatial, pairs)
scHOT_spatial <- scHOT_setWeightMatrix(scHOT_spatial,
                                       positionColData = c("x","y"),
                                        positionType = "spatial",
                                        nrow.out = NULL,
                                        span = 0.05)
scHOT_spatial <- scHOT_calculateGlobalHigherOrderFunction(
  scHOT_spatial,
  higherOrderFunction = weightedSpearman,
  higherOrderFunctionType = "weighted")
scHOT_spatial <- scHOT_setPermutationScaffold(scHOT_spatial,
                                              numberPermutations = 100)

}
