% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_Atlas.R
\name{download_Atlas}
\alias{download_Atlas}
\title{Download and Load an RDS File from a URL}
\usage{
download_Atlas(file_url)
}
\arguments{
\item{file_url}{Character; URL of the RDS file to download.}
}
\value{
An R object loaded from the downloaded RDS file.
}
\description{
Downloads an RDS file from a specified URL and reads its contents into R.
We used it for https://www.singlecellatlas.org
}
\details{
This function uses \pkg{httr} to perform the download. The RDS file is read
directly from a raw connection without saving to disk. An internet connection
is required.

If the download fails (e.g., invalid URL, server error), an informative error
message is returned.
}
\examples{
url <- "https://zenodo.org/records/15511027/files/sce_obj.rds?download=1"
atlas_data <- download_Atlas(url)
}
