% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_topology_metrics.R
\name{compute_topology_metrics}
\alias{compute_topology_metrics}
\title{Compute Network Topological Properties}
\usage{
compute_topology_metrics(control_output, predicted_list)
}
\arguments{
\item{control_output}{A list output from \code{community_path()} representing the
ground truth network. Must contain a \code{graph} (igraph object) and
\code{communities$membership}.}

\item{predicted_list}{A list of lists, each output from \code{community_path()}
representing predicted networks.}
}
\value{
A list containing:
\itemize{
\item \code{topology_measures}: A data frame with Modularity,Communities,
Density, and Transitivity for each prediction.
\item \code{control_topology}: A numeric vector of the same metrics
for the control network.
}
}
\description{
Calculates topological properties (modularity, number of communities,
density, transitivity) for one or more networks.
}
\details{
This function requires the \strong{igraph} package. Topological
metrics include:
\itemize{
\item Modularity: Quality of community division
\item Communities: Number of detected communities
\item Density: Proportion of actual vs. possible edges
\item Transitivity: Clustering coefficient
}
}
\examples{
data(toy_counts)
data(toy_adj_matrix)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)

# Generate adjacency matrices
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# Apply cutoff
binary_se <- cutoff_adjacency(
    count_matrices = toy_counts,
    weighted_adjm_list = swadj_se,
    n = 1,
    method = "GENIE3",
    quantile_threshold = 0.95,
    nCores = 1
)

consensus <- create_consensus(binary_se, method = "union")
comm_cons <- community_path(consensus)
comm_truth <- community_path(toy_adj_matrix)

topo <- compute_topology_metrics(comm_truth, list(comm_cons))
}
