% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCzinb_internal.R
\name{nb.loglik.regression}
\alias{nb.loglik.regression}
\title{log-likelihood of the NB regression model}
\usage{
nb.loglik.regression(
  alpha,
  Y,
  A.mu = matrix(nrow = length(Y), ncol = 0),
  C.theta = matrix(0, nrow = length(Y), ncol = 1)
)
}
\arguments{
\item{alpha}{the vectors of parameters a.mu concatenated}

\item{Y}{the vector of counts}

\item{A.mu}{matrix of the model (see Details, default=empty)}

\item{C.theta}{matrix of the model (\eqn{log(\theta)}, default=zero)}
}
\value{
the log-likelihood.
}
\description{
This function computes the log-likelihood of a NB regression
model given a vector of counts.
}
\details{
The regression model is parametrized as follows: \deqn{log(\mu) =
  A_\mu * a_\mu}  \deqn{log(\theta) = C_\theta}
where \eqn{\mu, \theta} are
respectively the vector of mean parameters of the NB distribution,
and the vector of inverse   dispersion parameters.  The
log-likelihood of a vector of parameters \eqn{\alpha = a_\mu}
}
\keyword{internal}
