% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{find_markers}
\alias{find_markers}
\title{find marker genes}
\usage{
find_markers(
  expression_matrix = NULL,
  cluster = NULL,
  selected_cluster = NULL,
  fitType = "local",
  dispersion_method = "per-condition",
  sharing_Mode = "maximum"
)
}
\arguments{
\item{expression_matrix}{is  a normalised expression matrix.}

\item{cluster}{corresponding cluster information in the expression_matrix
by running CORE clustering or using other methods.}

\item{selected_cluster}{a vector of unique cluster ids to calculate}

\item{fitType}{string specifying 'local' or 'parametric' for DEseq dispersion
estimation}

\item{dispersion_method}{one of the options c( 'pooled', 'pooled-CR', 
per-condition', 'blind' )}

\item{sharing_Mode}{one of the options c("maximum", "fit-only", 
"gene-est-only")}
}
\value{
a \code{list} containing sorted DESeq analysis results
}
\description{
Find DE genes from comparing one clust vs remaining
}
\examples{
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
# depending on the data, the DESeq::estimateDispersions function requires
# suitable fitType
# and dispersion_method options
DEgenes <- find_markers(expression_matrix=assay(mixedpop1),
                        cluster = colData(mixedpop1)[,1],
                        selected_cluster=c(1), #can also run for more
                        #than one clusters, e.g.selected_cluster = c(1,2)
                        fitType = "parametric", 
                        dispersion_method = "blind",
                        sharing_Mode="fit-only"
                        )
names(DEgenes)
}
\author{
Quan Nguyen, 2017-11-25
}
