% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_Morans_I}
\alias{run_Morans_I}
\title{Generate Moran's I}
\usage{
run_Morans_I(data, type = "spatial_p", ncores = 1)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{type}{The type of dataset, either "scrna", "spatial_t", or "spatial_p".}

\item{ncores}{Number of cores for parallel processing.}
}
\value{
a dataframe of samples x features
The features are in the form of protein 1, protein 2 ... etc, with the numbers
representing Moran's value.
}
\description{
This function calculates Moran's I to measure spatial autocorrelation,
which an indicattion of how strongly the feature(ie, genes/proteins)
expression values in a sample cluster or disperse. A value closer to 1
indicates clustering of similar values and a value closer to -1 indicates
clustering of dissimilar values. A value of 0 indicates no particular clustering
structure, ie, the values are spatially distributed randomly.
The function supports spatial proteomics and spatial transcriptomics.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq[1:50, 1:20]
celltype <- data$celltype 
data <- data@assays$RNA@data
sample <- sample( c("patient1", "patient2", "patient3"), ncol(data) , replace= TRUE )
x <- sample(1:100, ncol(data) , replace = TRUE)
y <- sample(1:100, ncol(data) , replace = TRUE)
spatialCoords <- list( x , y)
alldata <- scFeatures:::formatData(data = data, sample = sample, celltype = celltype, 
spatialCoords  = spatialCoords )

feature_Morans_I <- run_Morans_I(alldata, type = "spatial_p", ncores = 1)

}
