% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_scfeatures.R
\name{run_CCI}
\alias{run_CCI}
\title{Generate cell cell communication score}
\usage{
run_CCI(data, type = "scrna", species = "Homo sapiens", ncores = 1)
}
\arguments{
\item{data}{A list object containing \code{data} matrix and \code{celltype} and \code{sample} vector.}

\item{type}{input data type, either scrna, spatial_p, or spatial_t}

\item{ncores}{number of cores}
}
\value{
a matrix of samples x features
The features are in the form of ligand 1 receptor 2 celltype a, ligand 1 receptor 2 celltype b ...
etc, with the numbers representing cell-cell interaction probability.
}
\description{
This function calculates the ligand receptor interaction score using CellChat
The output features are in the form of celltype a -> celltype b -- ligand 1 -> receptor 2 ,
which indicates the interaction between ligand 1 in celltype a and receptor 2 in celltype b.

It supports scRNA-seq.
}
\examples{

utils::data("example_scrnaseq" , package = "scFeatures")
data <- example_scrnaseq[1:1000, 1:100]
celltype <- data$celltype
sample <- data$sample
data <- as.matrix(data@assays$RNA@data)

alldata <- scFeatures:::formatData(data = data, celltype = celltype, sample = sample )
if (requireNamespace("CellChat", quietly = TRUE)) {
  feature_CCI <- run_CCI(alldata, type = "scrna", ncores = 1)
}
}
