% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_bin_cutoff.R
\name{determine_bin_cutoff}
\alias{determine_bin_cutoff}
\title{Determine a threshold for selecting bins of features
based on the metric table}
\usage{
determine_bin_cutoff(metric_table, threshold = 2,
  selected_metric = c("mean", "median", "score"),
  random_function_summarisation = mean)
}
\arguments{
\item{metric_table}{A data frame, usually the output of \code{\link{get_mean_median}}.}

\item{threshold}{How many time higher than the background should the last bin be? Default to 2.}

\item{selected_metric}{Which metric to use (i.e. which column from metric_table to work with).
Default to \code{mean}.}

\item{random_function_summarisation}{A function used to aggregate the
randomised control across
bin. Default to \code{mean}.}
}
\value{
A number, the first bin of features to discard.
}
\description{
Takes the output of \code{\link{get_mean_median}} and decide until which window to keep
based on background level and a threshold.
}
\details{
Background level is estimated by averaging correlation coefficient obtained
from the top window randomisations.

Bins (or windows) of features are kept until the mean (or median)
correlation coefficient falls under
a threshold value \code{threshold x background level}.
}
\examples{
myData <- tibble::tibble(
    bin = rep(c(1, 2, 3), each = 3),
    window = rep(c("top_window", "shuffled_top_window_1", "shuffled_top_window_2"), 3),
    mean = c(0.8, 0.1, 0.11, 0.14, 0.12, 0.09, 0.10, 0.13, 0.08)
)
determine_bin_cutoff(myData)

}
\seealso{
\code{\link{get_mean_median}}, \code{\link{plot_metric}}
}
