#' Expression data from 32 human embryonic stem cells
#'
#' Expression of 60,468 Gencode gene (in FPKM) from 32 single cell RNAseq
#' of human embryonic stem cells
#'
#' @return A \code{tibble}.
#'
#' @format A \code{tibble} with 60,468 rows (genes) and 33 columns (cells):
#' \describe{
#'   \item{tracking_id}{The Gencode human encode gene id}
#'   \item{next 33 columns}{Single embryonic stem cells}
#' }
#' @source The example dataset was processed by Mantsoki et al. (2016)
#' \url{https://www.ncbi.nlm.nih.gov/pubmed/26951854},
#' data from human Embryonic Stem cells was generated by Yan et al.
#' (2013)\url{https://www.ncbi.nlm.nih.gov/pubmed/23934149}.
"scData_hESC"