% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_lrt.R
\name{perform_lrt}
\alias{perform_lrt}
\title{Perform the likelihood ratio test}
\usage{
perform_lrt(alter_marginal, null_marginal)
}
\arguments{
\item{alter_marginal}{A list of marginal models from the alternative hypothesis.}

\item{null_marginal}{A list of marginal models from the null hypothesis. It must be strictly nested in the alternative model.}
}
\value{
A data.frame of the LRT result.
}
\description{
\code{perform_lrt} performs the likelihood ratio test to compare two list of marginal models.
}
\details{
The function takes two lists of marginal models (by default, the first list is the alternative and the second is the null)
from \code{\link{fit_marginal}}. Note that LRT only makes sense for NESTED models. This can be quite tricky if you use penalized-splines (e.g., for trajectory data).
}
\examples{
data(example_sce)
my_data <- construct_data(
sce = example_sce,
assay_use = "counts",
celltype = "cell_type",
pseudotime = "pseudotime",
spatial = NULL,
other_covariates = NULL,
corr_by = "cell_type"
)

my_data2 <- construct_data(
  sce = example_sce,
  assay_use = "counts",
  celltype = "cell_type",
  pseudotime = "pseudotime",
  spatial = NULL,
  other_covariates = NULL,
  corr_by = "pseudotime",
  ncell = 10000
)

my_marginal1 <- fit_marginal(
  data = my_data,
  mu_formula = "1",
  sigma_formula = "1",
  family_use = "nb",
  n_cores = 1,
  usebam = FALSE
)
my_marginal2 <- fit_marginal(
  data = my_data,
  mu_formula = "s(pseudotime, bs = 'cr', k = 10)",
  sigma_formula = "1",
  family_use = "nb",
  n_cores = 1,
  usebam = FALSE
)
my_fit1 <- lapply(my_marginal1, function(x)x$fit)
my_fit2 <- lapply(my_marginal2, function(x)x$fit)
my_pvalue <- perform_lrt(my_fit2, my_fit1)

}
