% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{mockDoubletSCE}
\alias{mockDoubletSCE}
\title{mockDoubletSCE}
\usage{
mockDoubletSCE(
  ncells = c(200, 300),
  ngenes = 200,
  mus = NULL,
  dbl.rate = 0.1,
  only.heterotypic = TRUE
)
}
\arguments{
\item{ncells}{A positive integer vector indicating the number of cells per
cluster (min 2 clusters)}

\item{ngenes}{The number of genes to simulate. Ignored if `mus` is given.}

\item{mus}{A list of cluster averages.}

\item{dbl.rate}{The doublet rate}

\item{only.heterotypic}{Whether to create only heterotypic doublets}
}
\value{
A SingleCellExperiment object, with the colData columns `type`
indicating whether the cell is a singlet or doublet, and `cluster`
indicating from which cluster (or cluster combination) it was simulated.
}
\description{
Creates a mock random single-cell experiment object with doublets
}
\examples{
sce <- mockDoubletSCE()
}
