% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getExpectedDoublets}
\alias{getExpectedDoublets}
\title{getExpectedDoublets}
\usage{
getExpectedDoublets(x, dbr = NULL, only.heterotypic = TRUE, dbr.per1k = 0.008)
}
\arguments{
\item{x}{A vector of cluster labels for each cell}

\item{dbr}{The expected doublet rate.}

\item{only.heterotypic}{Logical; whether to return expectations only for
heterotypic doublets}

\item{dbr.per1k}{The expected proportion of doublets per 1000 cells.}
}
\value{
The expected number of doublets of each combination of clusters
}
\description{
getExpectedDoublets
}
\examples{
# random cluster labels
cl <- sample(head(LETTERS,4), size=2000, prob=c(.4,.2,.2,.2), replace=TRUE)
getExpectedDoublets(cl)
}
