% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atac.R
\name{clamulet}
\alias{clamulet}
\title{clamulet}
\usage{
clamulet(
  x,
  artificialDoublets = NULL,
  iter = 2,
  k = NULL,
  minCount = 0.001,
  maxN = 500,
  nfeatures = 25,
  max_depth = 5,
  threshold = 0.75,
  returnAll = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{The path to a fragment file (see \code{\link{getFragmentOverlaps}}
for performance/memory-related guidelines)}

\item{artificialDoublets}{The number of artificial doublets to generate}

\item{iter}{The number of learning iterations (should be 1 to)}

\item{k}{The number(s) of nearest neighbors at which to gather statistics}

\item{minCount}{The minimum number of cells in which a locus is detected to
be considered. If lower than 1, it is interpreted as a fraction of the 
number of cells.}

\item{maxN}{The maximum number of regions per cell to consider to establish
windows for meta-features}

\item{nfeatures}{The number of meta-features to consider}

\item{max_depth}{The maximum tree depth}

\item{threshold}{The score threshold used during iterations}

\item{returnAll}{Logical; whether to return data also for artificial doublets}

\item{verbose}{Logical; whether to print progress information}

\item{...}{Arguments passed to \code{\link{getFragmentOverlaps}}}
}
\value{
A data.frame
}
\description{
Classification-powered Amulet-like method
}
\details{
`clamulet` operates similarly to the `scDblFinder` method, but generates 
doublets by operating on the fragment coverages. This has the advantage that
the number of loci covered by more than two reads can be computed for 
artificial doublets, enabling the use of this feature (along with the 
kNN-based ones) in a classification scheme. It however has the disadvantage
of being rather slow and memory hungry, and appears to be outperformed by a
simple p-value combination of the two methods (see vignette).
}
