% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_scClassify.R
\name{train_scClassify}
\alias{train_scClassify}
\title{Training scClassify model}
\usage{
train_scClassify(
  exprsMat_train,
  cellTypes_train,
  tree = "HOPACH",
  selectFeatures = "limma",
  topN = 50,
  hopach_kmax = 5,
  pSig = 0.05,
  cellType_tree = NULL,
  weightsCal = FALSE,
  parallel = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  verbose = TRUE,
  returnList = TRUE,
  ...
)
}
\arguments{
\item{exprsMat_train}{A matrix of log-transformed expression matrix of reference dataset}

\item{cellTypes_train}{A vector of cell types of reference dataset}

\item{tree}{A vector indicates the method to build hierarchical tree,
set as "HOPACH" by default.
This should be one of "HOPACH" and "HC" (using stats::hclust).}

\item{selectFeatures}{A vector indicates the gene selection method,
set as "limma" by default.
This should be one or more of "limma", "DV", "DD", "chisq", "BI", "Cepo".}

\item{topN}{An integer indicates the top number of features that are selected}

\item{hopach_kmax}{An integer between 1 and 9 specifying the maximum number of
children at each node in the HOPACH tree.}

\item{pSig}{A numeric indicates the cutoff of pvalue for features}

\item{cellType_tree}{A list indicates the cell type tree provided by user.
(By default, it is NULL)}

\item{weightsCal}{A logical input indicates whether we need to
calculate the weights for the model.}

\item{parallel}{A logical input indicates whether the algorihms will run in parallel}

\item{BPPARAM}{A \code{BiocParallelParam} class object
from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{verbose}{A logical input indicates whether the intermediate steps will be printed}

\item{returnList}{A logical input indicates whether the output will be class of list}

\item{...}{Other input for predict_scClassify for the case when weights calculation
of the pretrained model is performed}
}
\value{
list of results or an object of \code{scClassifyTrainModel}
}
\description{
Training scClassify model
}
\examples{
data("scClassify_example")
xin_cellTypes <- scClassify_example$xin_cellTypes
exprsMat_xin_subset <- scClassify_example$exprsMat_xin_subset
trainClass <- train_scClassify(exprsMat_train = exprsMat_xin_subset,
cellTypes_train = xin_cellTypes,
selectFeatures = c("limma", "BI"),
returnList = FALSE
)

}
\author{
Yingxin Lin
}
