% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saseRfit.R
\name{saseRfit}
\alias{saseRfit}
\title{Searching for aberrant expression or splicing.}
\usage{
saseRfit(
  se,
  analysis,
  dimensions = NULL,
  padjust = "BH",
  BPPARAM = bpparam(),
  fit = "fast",
  scale = TRUE,
  robustPCA = FALSE,
  ignore_samples = NULL
)
}
\arguments{
\item{se}{A `SummarizedExperiment` instance generated with the
SummarizedExperiment function of the SummarizedExperiment package.
In the assay slot, provide the expression counts as an
ordinary `matrix`, `DataFrame`, a `sparseMatrix` or a `DelayedMatrix`.
`colData` is a `DataFrame` describing the samples in the experiment.
Finally, specify the experimental design as a formula in the metadata slot.
This formula must be based on the colData, or equal to ~1 in case of
modelling only an intercept. If 'optimalEncDim' is available in the metadata
slot, this number will be used as the number of latent factors.}

\item{analysis}{`AE` for aberrant expression analysis, `AS` for aberrant
splicing analysis, and `proportion` for any other kind of analysis using
proportions.}

\item{dimensions}{A single integer representing the number of latent factors
that are used in the regression framework. If not specified, the
'optimalEncDim' in the metadata slot will be used. If nor 'optimalEncDim' is
specified, the Gavish and Donoho threshold for singular values will be used.}

\item{padjust}{the method used to compute FDR-adjusted p-values. Look at the
documentation of the `p.adjust` package for different options. Both
Benjamini-Hochberg ('BH') or Benjamini-Yekutieli ('BY') are recommended.}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{bpparam} in \code{BiocParallel} package for details.}

\item{fit}{character value. Both `fast` or `edgeR` can be used.
`fast` uses a quadratic mean-variance relationship for fast estimation of
the mean when many covariates or latent factors are included, without
compromising upon power. `edgeR` can be used to perform parameter estimation
, although not scaling well with many covariates or latent factors.}

\item{scale}{logical value to scale the deviance residuals before
performing the singular value decomposition.}

\item{robustPCA}{This argument is in beta phase and should be used carefully.
Logical value to perform robust PCA using the `PcaHubert`
function, which decreases the influence of outlier values on the estimated
latent factors.}

\item{ignore_samples}{This argument is in beta phase and should be used carefully.
Character vector with names of samples that are not
used when performing the latent factor estimation and estimation of the
regression coefficients.}
}
\value{
An updated `SummarizedExperiment` instance, now including a matrix
of p-values (`pValue`) and a matrix of FDR-adjusted p-values
(`pValueAdjust`) in the assay slot. Also `pValueAdjustMethod` is available
in the metadata slot, stating which method was used to obtain FDR-adjusted
pvalues. If analysis is `AS` or `proportion`, also `pValuesLocus`, an
aggregated p-value is provided based on the `locus` column in the rowData.
This is calculated by taking the minimal p-values.
}
\description{
saseRfit is used to perform a negative binomial regression and to search
for aberrant expression or splicing in the context of rare Mendelian
disorders. To model aberrant splicing, it uses adapted offsets to model
proportions. It uses a predefined or an estimated optimal number of latent
factors in the regression. It returns the p-values for the prioritisation
of aberrant expression or splicing.
}
\examples{
data(saseRExample, package = "saseR")

SEgenes <- saseRfit(SEgenes,
                    analysis = "AE",
                    padjust = "BH",
                    fit = "fast")
SEbins <- saseRfit(SEbins,
                   analysis = "AS",
                   padjust = "BH",
                   fit = "fast")
SEjunctions <- saseRfit(SEjunctions,
                        analysis = "AS",
                        padjust = "BH",
                        fit = "fast")
}
