% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateGRC.R
\name{sracipeSimulate}
\alias{sracipeSimulate}
\title{Simulate a gene regulatory circuit}
\usage{
sracipeSimulate(
  circuit = "inputs/test.tpo",
  config = config,
  anneal = FALSE,
  knockOut = NA_character_,
  numModels = 2000,
  paramRange = 100,
  prodRateMin = 1,
  prodRateMax = 100,
  degRateMin = 0.1,
  degRateMax = 1,
  foldChangeMin = 1,
  foldChangeMax = 100,
  hillCoeffMin = 1L,
  hillCoeffMax = 6L,
  integrateStepSize = 0.02,
  simulationTime = 50,
  nIC = 1L,
  nNoise = 0L,
  simDet = TRUE,
  initialNoise = 50,
  noiseScalingFactor = 0.5,
  shotNoise = 0,
  ouNoise_t = 1,
  scaledNoise = FALSE,
  outputPrecision = 12L,
  printStart = 50,
  printInterval = 10,
  stepper = "RK4",
  thresholdModels = 5000,
  plots = FALSE,
  plotToFile = FALSE,
  genIC = TRUE,
  genParams = TRUE,
  integrate = TRUE,
  rkTolerance = 0.01,
  timeSeries = FALSE,
  signalRate = 10,
  uniqueDigits = 4,
  convergThresh = 1e-12,
  numStepsConverge = 500,
  numConvergenceIter = 25,
  limitcycles = FALSE,
  LCSimTime = 10,
  LCSimStepSize = 0.01,
  maxLCs = 10,
  LCIter = 20,
  maxPeriods = 100,
  numSampledPeriods = 3,
  allowedPeriodError = 3,
  samePointProximity = 0.1,
  LCStepper = "RK4",
  paramSignalVals = data.frame(),
  geneClamping = data.frame(),
  nCores = 1L,
  ...
)
}
\arguments{
\item{circuit}{data.frame or character. The file containing the circuit or}

\item{config}{(optional) List. It contains simulation parameters
like integration method
(stepper) and other lists or vectors like simParams,
stochParams, hyperParams, options, thresholds etc.
The list simParams contains values for parameters like the
number of models (numModels),
simulation time (simulationTime), step size for simulations
(integrateStepSize), when to start recording the gene expressions
(printStart), time interval between recordings (printInterval), number of
initial conditions (nIC), output precision (outputPrecision), tolerance for
adaptive runge kutta method (rkTolerance), parametric variation (paramRange).
The list stochParams contains the parameters for stochastic simulations like
the number of noise levels to be simulated (nNoise), the ratio of subsequent
noise levels (noiseScalingFactor), maximum noise (initialNoise), whether to
use same noise for all genes or to scale it as per the median expression of
the genes (scaledNoise), ratio of shot noise to additive noise (shotNoise).
The list hyperParams contains the parameters like the minimum and maximum
production and degration of the genes, fold change, hill coefficient etc.
The list options includes logical values like annealing (anneal), scaling of
noise (scaledNoise), generation of new initial conditions (genIC), parameters
(genParams) and whether to integrate or not (integrate). The user
modifiable simulation options can be specified as other arguments. This
list should be used if one wants to modify many settings for multiple
simulations.}

\item{anneal}{(optional) Logical. Default FALSE. Whether to use annealing
for stochastic simulations. If TRUE, the gene expressions at higher noise
are used as initial conditions for simulations at lower noise.}

\item{knockOut}{(optional) List of character or vector of characters.
Simulation after knocking out one or more genes. To knock out all the genes
in the circuit, use \code{knockOut = "all"}. If it is a vector, then all
the genes in the vector will be knocked out simultaneously.}

\item{numModels}{(optional) Integer. Default 2000. Number of random models
to be simulated.}

\item{paramRange}{(optional) numeric (0-100). Default 100. The relative
range of parameters (production rate, degradation rate, fold change).}

\item{prodRateMin}{(optional) numeric. Default 1. Minimum production rate.}

\item{prodRateMax}{(optional) numeric. Default 100. Maximum production rate.}

\item{degRateMin}{(optional) numeric. Default 0.1. Minimum degradation rate.}

\item{degRateMax}{(optional) numeric. Default 1. Maximum degradation rate.}

\item{foldChangeMin}{(optional) numeric. Default 1. Minimum fold change for
interactions.}

\item{foldChangeMax}{(optional) numeric. Default 100. Maximum fold change for
interactions.}

\item{hillCoeffMin}{(optional) integer. Default 1. Minimum hill coefficient.}

\item{hillCoeffMax}{(optional) integer. Default 6. Maximum hill coefficient.}

\item{integrateStepSize}{(optional) numeric. Default 0.02. step size for
integration using "EM" and "RK4" steppers.}

\item{simulationTime}{(optional) numeric. Default 50. Total simulation time.
Only used for stochastic and time series simulations. For adjusting
deterministic simulation run times, see numConvergenceIter.}

\item{nIC}{(optional) integer. Default 1. Number of initial conditions to be
simulated for each model.}

\item{nNoise}{(optional) integer. Default 0.
Number of noise levels at which simulations
are to be done. Use nNoise = 1 if simulations are to be carried out at a
specific noise. If nNoise > 0, simulations will be carried out at nNoise
levels as well as for zero noise. "EM" stepper will be used for simulations
and any argument for stepper will be ignoired.}

\item{simDet}{(optional) logical. Default TRUE.
Whether to simulate at zero noise as well also when using nNoise > 0.}

\item{initialNoise}{(optional) numeric.
Default 50/sqrt(number of genes in the circuit). The initial value of noise
for simulations. The noise value will decrease by a factor
\code{noiseScalingFactor} at subsequent noise levels.}

\item{noiseScalingFactor}{(optional) numeric (0-1) Default 0.5.
The factor by which noise
will be decreased when nNoise > 1.}

\item{shotNoise}{(optional) numeric. Default 0.
The ratio of shot noise to additive
noise.}

\item{ouNoise_t}{(optional) numeric. Default 1. Correlation time parameter
for OU noise. Only used when "EM_OU" stepper is selected}

\item{scaledNoise}{(optional) logical. Default FALSE. Whether to scale the
noise in each gene by its expected median expression across all models. If
TRUE the noise in each gene will be proportional to its expression levels.}

\item{outputPrecision}{(optional) integer. Default 12.
The decimal point precison of
the output.}

\item{printStart}{(optional) numeric (0-\code{simulationTime}).
Default \code{simulationTime}. To be used only when \code{timeSeries} is
\code{TRUE}.
The time from which the output should be recorded. Useful for time series
analysis and studying the dynamics of a model for a particular initial
condition.}

\item{printInterval}{(optional) numeric (\code{integrateStepSize}-
\code{simulationTime - printStart}). Default 10. The separation between
two recorded time points for a given trajectory.
To be used only when \code{timeSeries} is
\code{TRUE}.}

\item{stepper}{(optional) Character. Stepper to be used for integrating the
differential equations. The options include \code{"EM"} for Euler-Maruyama
O(1), \code{"RK4"}
for fourth order Runge-Kutta O(4) and \code{"DP"} for adaptive stepper based
Dormand-Prince algorithm. The default method is \code{"RK4"}
 for deterministic
simulations and the method defaults to \code{"EM"}
for stochastic simulations.}

\item{thresholdModels}{(optional)  integer. Default 5000. The number of
models to be used for calculating the thresholds for genes.}

\item{plots}{(optional) logical Default \code{FALSE}.
Whether to plot the simuated data.}

\item{plotToFile}{(optional) Default \code{FALSE}. Whether to save the plots
to a file.}

\item{genIC}{(optional) logical. Default \code{TRUE}. Whether to generate
the initial conditions. If \code{FALSE}, the initial conditions must be
supplied as a dataframe to \code{circuit$ic}.}

\item{genParams}{(optional) logical. Default \code{TRUE}. Whether to generate
the parameters. If \code{FALSE}, the parameters must be
supplied as a dataframe to \code{circuit$params}.}

\item{integrate}{(optional) logical. Default \code{TRUE}. Whether to
integrate the differential equations or not. If \code{FALSE}, the function
will only generate the parameters and initial conditions. This can be used
iteratively as one can fist generate the parameters and initial conditions
and then modify these before using these modified values for integration.
For example, this can be used to knockOut genes by changing the production
rate and initial condition to zero.}

\item{rkTolerance}{(optional) numeric. Default \code{0.01}. Error tolerance
for adaptive integration method.}

\item{timeSeries}{(optional) logical. Default \code{FALSE}.
Whether to generate time series for a single model instead of performing
RACIPE simulations.}

\item{signalRate}{(optional) numeric. Default \code{10}. The factor by which
the differential equations for fast genes are multiplied by. Fast genes only
have inward signaling interactions of types 5 or 6}

\item{uniqueDigits}{(optional) integer. Default \code{4}. Deterministic
simulations with nIC > 1 count the number of unique steady states per model
by truncating the expression by this many digits and counting the number of
unique expressions}

\item{convergThresh}{(optional) numeric. Default \code{1e-12}. The threshold
for convergence to a steady state for deterministic simulations.}

\item{numStepsConverge}{(optional) integer Default \code{500}. The number of
integration steps between convergence tests for deterministic simulations.}

\item{numConvergenceIter}{(optional) integer. Default \code{25}. The total
number of convergence test iterations to run per model
initial condition in deterministic simulations.}

\item{limitcycles}{(optional) logical. Default \code{FALSE}. Whether to check
for limit cycles in deterministic simulations.}

\item{LCSimTime}{(optional) numeric. Default \code{10}. The length of each
iteration for the secondary limit cycle simulation}

\item{LCSimStepSize}{(optional) numeric. Default \code{0.01}. The integration
step size for the secondary limit cycle simulation.}

\item{maxLCs}{(optional) integer. Default \code{10}. The maximum allowable
number of limit cycles that can be detected for each model.}

\item{LCIter}{(optional) integer. Default \code{20}. The number of iterations
to run in the secondary limit cycle simulation}

\item{maxPeriods}{(optional) integer. Default \code{100}. The number of periods
to count in the distance function constructed by the limit cycle detection
algorithm}

\item{numSampledPeriods}{(optional) integer. Default \code{3}. The number of
times the limit cycle detection algorithm tries to calculate the period of the
simulated trajectory using the local minima in a constructed distance function.}

\item{allowedPeriodError}{(optional) integer. Default \code{3}. The allowed
difference in the sampled periods for a trajectory from the limit cycle
detection algorithm. Decrease this value to make for more stringent limit
cycle detection}

\item{samePointProximity}{(optional) numeric. Default \code{0.1}. The max
allowed square euclidean difference between two minima of the distance function
constructed by the limit cycle detection algorithm before they are considered
different points in phase space.}

\item{LCStepper}{(optional) Character. Default \code{"RK4"} The integration
method used for the limit cycle simulation. The options include \code{"E"}
for first order Euler and \code{"RK4"} for fourth order Runge Kutta. Any other
input will cause the simulation to use the Euler method}

\item{paramSignalVals}{(optional) Data Frame. Default data.frame(). The
first column must be a vector of time values with the first element as 0 and
the last element as simulationTime. The other column names must be valid
production or degradation parameter names for the circuit. Use
sracipeGenParamNames() to generate valid parameter names. The
first column must be a vector of time values with the first element as 0 and
the last element as simulationTime.}

\item{geneClamping}{(optional) Data Frame. Default data.frame(). The column
names must be genes in the circuit. The number of columns must either be one
or equal to numModels. If the number of columns is one, the selected genes
are clamped to those values for every model. Otherwise, the gene is clamped
to the value of the corresponding row for a particular model. If genIC is
set to \code{FALSE} while geneClamping is provided, the provided clamps will
override the original initial conditions.}

\item{nCores}{(optional) integer. Default \code{1}
Number of cores to be used for computation. Utilizes \code{multisession} from
\code{doFuture} pacakge, as well and \code{doRNG} package.}

\item{...}{Other arguments}
}
\value{
\code{RacipeSE} object. RacipeSE class inherits
\code{SummarizedExperiment} and contains the circuit, parameters,
initial conditions,
simulated gene expressions, and simulation configuration. These can be
accessed using correponding getters.
}
\description{
Simulate a gene regulatory circuit using its topology as the
only input. It will generate an ensemble of random models.
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}}
}

\examples{
data("demoCircuit")
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit)
}
