% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipeCircuit}
\alias{sracipeCircuit}
\alias{sracipeCircuit,RacipeSE-method}
\title{Method to get the circuit}
\usage{
sracipeCircuit(.object)

\S4method{sracipeCircuit}{RacipeSE}(.object)
}
\arguments{
\item{.object}{RacipeSE object}
}
\value{
A dataframe
}
\description{
The circuit file should contain three columns with headers,
"Source" "Target" "Type"
Here "Source" and "Target" are the names of the genes and "Type" refers to
the regulation, "1" for TF activation and "2" for TF inhibition, "3" for
degradation inhibition, "4" for degradation activation, "5" for signaling
activation, and "6" for signaling inhibition.
}
\examples{
rs <- RacipeSE()
data("demoCircuit")
sracipeCircuit(rs) <- demoCircuit
circuitDataFrame <- sracipeCircuit(rs)
rm(rs, demoCircuit,circuitDataFrame)

}
