# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Set the parameters for runibic algorithm
#'
#' runibic function for setting parameters
#'
#' @param t consistency level of the block (0.5-1.0] 
#' @param q a double value for quantile discretization
#' @param f filtering overlapping blocks, default 1(do not remove any blocks)
#' @param nbic maximum number of biclusters in output
#' @param div number of ranks as which we treat the up(down)-regulated value: default: 0==ncol(x)
#' @param useLegacy boolean value for legacy parameters management
#' @return NULL (an empty value)
#'
#' @seealso \code{\link{runibic}}
#' @examples
#' set_runibic_params(0.85, 0, 1, 100, 0, FALSE)
#'
set_runibic_params <- function(t = 0.85, q = 0, f = 1, nbic = 100L, div = 0L, useLegacy = FALSE) {
    invisible(.Call('_runibic_set_runibic_params', PACKAGE = 'runibic', t, q, f, nbic, div, useLegacy))
}

#' Discretize an input matrix 
#'
#' This function discretizes the input matrix. 
#' \code{\link{runiDiscretize}} uses paramaters: 'div' and 'q', 
#' which are set by set_runibic_params function.
#' The funtion returns a discrete matrix with given number of ranks 
#' based on the parameter div. In contrast to biclust::discretize
#' the function takes into consideration the quantile parameter 'q'. 
#' When 'q' parameter is higher or equal 0.5 a simple discretization is used
#' with equal sizes of the levels using the quantiles. If 'q' parameter 
#' is lower than 0.5 we use up(down)-regulated discretization divided
#' into three parts.
#' 
#' @seealso \code{\link{set_runibic_params}} \code{\link{calculateLCS}} \code{\link[biclust]{discretize}}
#' @param x a numeric matrix
#' @return a discretized matrix containing integers only
#'
#' @examples
#' A <- replicate(10, rnorm(20))
#' runiDiscretize(A)
#'
runiDiscretize <- function(x) {
    .Call('_runibic_runiDiscretize', PACKAGE = 'runibic', x)
}

#' Computing the indexes of j-th smallest values of each row
#'
#' This function sorts separately each row of a integer matrix 
#' and returns a matrix in which the value in i-th row and j-th column 
#' represent the index of the j-th smallest value of the i-th row.
#'
#' @param x a integer matrix
#' @return a integer matrix with indexes indicating positions 
#' of j-th smallest element in each row
#'
#' @examples
#' A <- matrix(c(4, 3, 1, 2, 5, 8, 6, 7), nrow=2, byrow=TRUE)
#' unisort(A)
#' @seealso \code{\link{runibic}} \code{\link{calculateLCS}} \code{\link{runiDiscretize}}
#'
#' @export
unisort <- function(x) {
    .Call('_runibic_unisort', PACKAGE = 'runibic', x)
}

#' Calculate a matrix of Longest Common Subsequence (LCS) 
#' between a pair of numeric vectors
#'
#' This function calculates the matrix with Longest Common Subsequence (LCS)
#' between two numeric vectors. From given matrix we can locate the size 
#' of the Longest Common Subsequence in the last column in the last row.
#'
#' @param x an integer vector
#' @param y an integer vector
#' @return a matrix computed using dynamic programming
#' that stores the Longest Common Subsequence (LCS) between two vectors A and B.
#' @seealso \code{\link{runibic}}  \code{\link{calculateLCS}} \code{\link{backtrackLCS}}
#'
#' @examples
#' A <- c(1, 2, 3, 4, 5)
#' B <- c(1, 2, 4)
#' pairwiseLCS(A, B)
#'
#' @export
pairwiseLCS <- function(x, y) {
    .Call('_runibic_pairwiseLCS', PACKAGE = 'runibic', x, y)
}

#' Retrieving a Longest Common Subsequence between two integer vectors.
#'
#' This function retrieves the Longest Common Subsequence (LCS)
#' between two integer vectors by backtracking the matrix 
#' obtained with dynamic programming.
#'
#' @param x an integer vector
#' @param y an integer vector
#' @return an integer vector containing the the Longest Common Subsequence (LCS)
#' between vectors x and y (i.e. the values that appear in both x and y in the same order)
#'
#' @examples
#' A <- c(1, 2, 3, 4, 5)
#' B <- c(1, 2, 4)
#' backtrackLCS(A, B)
#' @seealso \code{\link{runibic}} \code{\link{pairwiseLCS}} \code{\link{calculateLCS}}
#'
#' @export
backtrackLCS <- function(x, y) {
    .Call('_runibic_backtrackLCS', PACKAGE = 'runibic', x, y)
}

#' Calculate all Longest Common Subsequences between a matrix.
#'
#' This function computes unique pairwise Longest Common Subsequences 
#' between each row of input matrix. The function outputs a list 
#' sorted by Longest Common Subsequences (LCS) length. The output list contains
#' the length of calculated LCS, indices, of the first and second rows
#' between which LCS was calculated.
#' The function uses two different sorting methods. The default one 
#' uses Fibonacci Heap used in original implementation of Unibic, 
#' the second one uses standard sorting algorithm from C++ STL.
#'
#' @param discreteInput is a input discrete matrix
#' @param useFibHeap boolean value for choosing which sorting method 
#' should be used in sorting of output
#' @return a list with sorted values based on calculation of the length of LCS
#' between all pairs of rows
#'
#' @examples
#' A <- matrix(c(4, 3, 1, 2, 5, 8, 6, 7), nrow=2, byrow=TRUE)
#' calculateLCS(A, TRUE)
#' @seealso \code{\link{runibic}} \code{\link{backtrackLCS}}  \code{\link{pairwiseLCS}}
#'
#' @export
calculateLCS <- function(discreteInput, useFibHeap = TRUE) {
    .Call('_runibic_calculateLCS', PACKAGE = 'runibic', discreteInput, useFibHeap)
}

#' Calculate biclusters from sorted list of LCS scores and row indices
#'
#' This function search for biclusters in the input matrix. 
#' The calculations are based on the integer matrix with indexes 
#' indicating positions of j-th smallest element in each row 
#' and the results from calculations of Longest Common Subsequence 
#' between all rows in the input matrix. The paramteres of this function can be
#' obtained from other functions provided by this package.
#' @seealso \code{\link{runibic}} \code{\link{calculateLCS}} \code{\link{unisort}}
#'
#' @param discreteInput an integer matrix with indices of sorted columns
#' @param discreteInputValues an integer matrix with discrete values
#' @param scores a numeric vector with LCS length
#' @param geneOne a numeric vector with first row indexes 
#' from pairwise LCS calculation 
#' @param geneTwo a numeric vector with second row indexes 
#' from pairwise LCS calculation 
#' @param rowNumber a int with number of rows in the input matrix
#' @param colNumber a int with number of columns in the input matrix
#' @return a list with information of found biclusters
#'
#' @examples
#' A <- matrix( c(4,3,1,2,5,8,6,7,9,10,11,12),nrow=4,byrow=TRUE)
#' iA <- unisort(A)
#' lcsResults <- calculateLCS(A)
#' cluster(iA, A, lcsResults$lcslen, lcsResults$a, lcsResults$b, nrow(A), ncol(A))
#'
#' @export
cluster <- function(discreteInput, discreteInputValues, scores, geneOne, geneTwo, rowNumber, colNumber) {
    .Call('_runibic_cluster', PACKAGE = 'runibic', discreteInput, discreteInputValues, scores, geneOne, geneTwo, rowNumber, colNumber)
}

