% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqt-generics.R, R/rqt-methods.R
\docType{methods}
\name{geneTest}
\alias{geneTest}
\alias{geneTest,rqt-method}
\title{This function performs a gene-level test based on combined effect sizes.}
\usage{
geneTest(obj, ...)

\S4method{geneTest}{rqt}(
  obj,
  perm = 0,
  STT = 0.2,
  weight = FALSE,
  cumvar.threshold = 75,
  out.type = "D",
  method = "pca",
  scaleData = FALSE,
  asym.pval = FALSE,
  penalty = 0.001,
  verbose = FALSE
)
}
\arguments{
\item{obj}{Object of class \code{rqt}}

\item{...}{Additional parameters to pass to the function}

\item{perm}{Integer indicating the number of permutations 
to compute p-values. Default: 0.}

\item{STT}{Numeric indicating soft truncation threshold (STT) 
to convert to gamma parameter (must be <= 0.4). 
Needed for an optimal parameter a in Gamma-distribution. Default: 0.2. 
See, for example, Fridley, et al 2013: "Soft truncation thresholding 
for gene set analysis of RNA-seq data: Application to a vaccine study".}

\item{weight}{Logical value. Indicates using weights (see Lee et al 2016). 
Default: FALSE.}

\item{cumvar.threshold}{Numeric value indicating 
the explained variance threshold for PCA-like methods. Default: 75}

\item{out.type}{Character, indicating a type of phenotype. 
Possible values: \code{D} (dichotomous or binary), 
\code{C} (continous or quantitative).}

\item{method}{Method used to reduce multicollinerity and account for LD. 
Default: \code{pca}. 
Another methods available: \code{lasso}, \code{ridge}, \code{pls}.}

\item{scaleData}{A logic parameter (TRUE/FALSE) indicating scaling of 
the genotype dataset.}

\item{asym.pval}{Indicates Monte Carlo approximation for p-values. Default: FALSE.}

\item{penalty}{A value of \code{penalty} parameter for LASSO/ridge regression.
Default: 0.001}

\item{verbose}{Indicates verbosing output. Default: FALSE.}
}
\value{
Updated rqt object with result slot

Object of class \code{rqt}
}
\description{
This function performs a gene-level test based on combined effect sizes.

geneTest
This function performs a gene-level test based on combined effect sizes.
}
\examples{
data <- data.matrix(read.table(system.file("extdata/test.bin1.dat",
package="rqt"), header=TRUE))
pheno <- data[,1]
geno <- data[, 2:dim(data)[2]]
colnames(geno) <- paste(seq(1, dim(geno)[2]))
geno.obj <- SummarizedExperiment(geno)
obj <- rqt(phenotype=pheno, genotype=geno.obj)
res <- geneTest(obj, method="pca", out.type = "D")
print(res)
}
