% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Rprimer-classes}
\alias{Rprimer-classes}
\alias{RprimerProfile-class}
\alias{.RprimerProfile}
\alias{RprimerProfile}
\alias{RprimerOligo-class}
\alias{.RprimerOligo}
\alias{RprimerOligo}
\alias{RprimerAssay-class}
\alias{.RprimerAssay}
\alias{RprimerAssay}
\alias{RprimerMatchOligo-class}
\alias{.RprimerMatchOligo}
\alias{RprimerMatchOligo}
\alias{RprimerMatchAssay-class}
\alias{.RprimerMatchAssay}
\alias{RprimerMatchAssay}
\alias{coerce}
\title{S4 classes for representation of different Rprimer objects}
\usage{
RprimerProfile(...)

RprimerOligo(...)

RprimerAssay(...)

RprimerMatchOligo(...)

RprimerMatchAssay(...)
}
\arguments{
\item{...}{A data frame or list to be converted into an Rprimer-object.}
}
\value{
An Rprimer-object if validation succeeds, an error
message otherwise.
}
\description{
The rprimer package contains five different S4 classes. Each class is used
as input or output for the different functions within the oligo and assay
design workflow:

 \itemize{
 \item \code{RprimerProfile}: output from \code{consensusProfile()},
 input for \code{oligos()}.
 \item \code{RprimerOligo}: output from \code{oligos()}, input
 for \code{assays()} and \code{checkMatch()}.
 \item \code{RprimerAssay}: output from \code{assays()}, input
 for \code{checkMatch()}.
 \item \code{RprimerMatchOligo}: output from \code{checkMatch()}.
 \item \code{RprimerMatchAssay}: output from \code{checkMatch()}.
}

These classes extends the DFrame class from S4vectors
(Pages et al., 2020), without any additional slots, but with some
additional checks for validity.
}
\section{Coercion}{

Each class can be converted to a traditional data frame, by using either
\code{as()} or \code{as.data.frame()}.

Moreover, \code{as()} can also be used for converting oligo sequences
within an
\code{RprimerOligo} or \code{RprimerAssay} object into a
\code{Biostrings::DNAStringSet}
object (Pages et al., 2020).
Note that all oligo sequences will be written in the
same direction as the input alignment that was used to generate
the oligos.
}

\examples{
## Constructors

data("exampleRprimerProfile")
x <- as.data.frame(exampleRprimerProfile)
RprimerProfile(x)

data("exampleRprimerOligo")
x <- as.data.frame(exampleRprimerOligo)
RprimerOligo(x)

data("exampleRprimerAssay")
x <- as.data.frame(exampleRprimerAssay)
RprimerAssay(x)

data("exampleRprimerMatchOligo")
x <- as.data.frame(exampleRprimerMatchOligo)
RprimerMatchOligo(x)

data("exampleRprimerMatchAssay")
x <- as.data.frame(exampleRprimerMatchAssay)
RprimerMatchAssay(x)

## Coercion methods for RprimerOligo and RprimerAssay objects

## Convert an RprimerOligo object to a DNAStringSet
data("exampleRprimerOligo")

## Pick rows to convert
x <- exampleRprimerOligo[1:2, ]
as(x, "DNAStringSet")

## Convert an RprimerAssay object to a DNAStringSet
data("exampleRprimerAssay")

## Pick rows to convert
x <- exampleRprimerAssay[1:2, ]
as(x, "DNAStringSet")
}
\references{
Pages, H., Lawrence, M., and Aboyoun, R. (2020). S4Vectors:
Foundation of vector-like and list-like containers in
Bioconductor. R package version 0.28.0.

Pages, H., Aboyoun, P., Gentleman R., and DebRoy S. (2020). Biostrings:
Efficient manipulation of biological strings. R package version
2.57.2.
}
\seealso{
consensusProfile, oligos, assays, checkMatch
}
