% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot,oplsMultiDataSet,ANY-method}
\alias{plot,oplsMultiDataSet,ANY-method}
\alias{plot,opls,ANY-method}
\alias{plot.opls}
\alias{plot,opls-method}
\alias{plot.oplsMultiDataSet}
\alias{plot,oplsMultiDataSet-method}
\title{Plot Method for (O)PLS(-DA)}
\usage{
\S4method{plot}{oplsMultiDataSet,ANY}(
  x,
  y,
  typeVc = c("correlation", "outlier", "overview", "permutation", "predict-train",
    "predict-test", "summary", "x-loading", "x-score", "x-variance", "xy-score",
    "xy-weight")[7],
  parAsColFcVn = NA,
  parCexN = 0.8,
  parCompVi = c(1, 2),
  parEllipsesL = NA,
  parLabVc = NA,
  parPaletteVc = NA,
  parTitleL = TRUE,
  parCexMetricN = NA,
  plotSubC = "",
  fig.pdfC = c("none", "interactive", "myfile.pdf")[2],
  info.txtC = c("none", "interactive", "myfile.txt")[2]
)

\S4method{plot}{opls,ANY}(
  x,
  y,
  typeVc = c("correlation", "outlier", "overview", "permutation", "predict-train",
    "predict-test", "summary", "x-loading", "x-score", "x-variance", "xy-score",
    "xy-weight")[7],
  parAsColFcVn = NA,
  parCexN = 0.8,
  parCompVi = c(1, 2),
  parEllipsesL = NA,
  parLabVc = NA,
  parPaletteVc = NA,
  parTitleL = TRUE,
  parCexMetricN = NA,
  plotSubC = "",
  fig.pdfC = c("none", "interactive", "myfile.pdf")[2],
  info.txtC = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{opls} or \code{oplsMultiDataSet},
created by the \code{opls} function.}

\item{y}{Currently not used}

\item{typeVc}{Character vector: the following plots are available:
'correlation': Variable correlations with the components, 'outlier':
Observation diagnostics (score and orthogonal distances), 'overview': Model
overview showing R2Ycum and Q2cum (or 'Variance explained' for PCA),
'permutation': Scatterplot of R2Y and Q2Y actual and simulated models after
random permutation of response values; 'predict-train' and 'predict-test':
Predicted vs Actual Y for reference and test sets (only if Y has a single
column), 'summary' [default]: 4-plot summary showing permutation, overview,
outlier, and x-score together, 'x-variance': Spread of raw variables
corresp. with min, median, and max variances, 'x-loading': X-loadings (the 6
of variables most contributing to loadings are colored in red to facilitate
interpretation), 'x-score': X-Scores, 'xy-score': XY-Scores, 'xy-weight':
XY-Weights}

\item{parAsColFcVn}{Optional factor character or numeric vector to be
converted into colors for the score plot; default is NA [ie colors will be
converted from 'y' in case of (O)PLS(-DA) or will be 'black' for PCA]}

\item{parCexN}{Numeric: amount by which plotting text should be magnified
relative to the default}

\item{parCompVi}{Integer vector of length 2: indices of the two components
to be displayed on the score plot (first two components by default)}

\item{parEllipsesL}{Should the Mahalanobis ellipses be drawn? If 'NA'
[default], ellipses are drawn when either a character parAsColVcn is
provided (PCA case), or when 'y' is a character factor ((O)PLS-DA cases).}

\item{parLabVc}{Optional character vector for the labels of observations on
the plot; default is NA [ie row names of 'x', if available, or indices of
'x', otherwise, will be used]}

\item{parPaletteVc}{Optional character vector of colors to be used in the plots}

\item{parTitleL}{Should the titles of the plots be printed on the graphics
(default = TRUE); It may be convenient to set this argument to FALSE when
the user wishes to add specific titles a posteriori}

\item{parCexMetricN}{Numeric: magnification of the metrics at the bottom of
score plot (default -NA- is 1 in 1x1 and 0.7 in 2x2 display)}

\item{plotSubC}{Character: Graphic subtitle}

\item{fig.pdfC}{Character: File name with '.pdf' extension for the figure;
if 'interactive' (default), figures will be displayed interactively; if 'none',
no figure will be generated}

\item{info.txtC}{Character: File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\description{
This function plots values based upon a model trained by \code{opls}.
}
\examples{

data(sacurine)
attach(sacurine)

for(typeC in c("correlation", "outlier", "overview",
               "permutation", "predict-train","predict-test",
               "summary", "x-loading", "x-score", "x-variance",
               "xy-score", "xy-weight")) {

    print(typeC)

    if(grepl("predict", typeC))
        subset <- "odd"
    else
        subset <- NULL

    plsModel <- opls(dataMatrix, sampleMetadata[, "gender"],
                     predI = ifelse(typeC != "xy-weight", 1, 2),
                     orthoI = ifelse(typeC != "xy-weight", 1, 0),
                     permI = ifelse(typeC == "permutation", 10, 0),
                     subset = subset,
                     info.txtC = "none",
                     fig.pdfC = "none")

    plot(plsModel, typeVc = typeC)

}

sacPlsda <- opls(dataMatrix, sampleMetadata[, "gender"])
plot(sacPlsda, parPaletteVc = c("green4", "magenta"))

detach(sacurine)

#### Application to an opls object generated by an ExpressionSet

sacSet <- sacurine[["eset"]]
                                                      
sacPlsda <- opls(sacSet, "gender")
plot(sacPlsda, typeVc = "x-score")

#### Application to a opls object generated by an MultiDataSet

data(NCI60)
nciMset <- NCI60[["mds"]]
# Restricting to the 'agilent' and 'hgu95' datasets
nciMset <- nciMset[, c("agilent", "hgu95")]
# Restricting to the 'ME' and 'LE' cancer types
sampleNamesVc <- Biobase::sampleNames(nciMset[["agilent"]])
cancerTypeVc <- Biobase::pData(nciMset[["agilent"]])[, "cancer"]
nciMset <- nciMset[sampleNamesVc[cancerTypeVc \%in\% c("ME", "LE")], ]
# Building PLS-DA models for the cancer type
nciPlsda <- opls(nciMset, "cancer", predI = 2)
plot(nciPlsda, typeVc = "x-score")

}
