% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/opls-methods.R
\name{getScoreMN}
\alias{getScoreMN}
\alias{getScoreMN,opls-method}
\title{getScoreMN method for PCA/(O)PLS(-DA) models}
\usage{
getScoreMN(object, orthoL = FALSE)

\S4method{getScoreMN}{opls}(object, orthoL = FALSE)
}
\arguments{
\item{object}{An S4 object of class \code{opls}, created by \code{opls}
function.}

\item{orthoL}{Logical: Should the orthogonal score matrix be returned
(default is FALSE and the predictive score matrix is returned)}
}
\value{
Numeric matrix with a number of rows equal to the number of samples
and a number of columns equal to the number of components
}
\description{
(Orthogonal) scores of the (O)PLS(-DA) model
}
\examples{

data(sacurine)
attach(sacurine)

sacurine.plsda <- opls(dataMatrix,
                       sampleMetadata[, "gender"])

getScoreMN(sacurine.plsda)

detach(sacurine)

}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
