% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{fromW4M}
\alias{fromW4M}
\title{fromW4M}
\usage{
fromW4M(
  dirC,
  namePatternC = "",
  fileTableNamesVc = c("dataMatrix", "sampleMetadata", "variableMetadata"),
  outputC = c("exp", "set")[2],
  verboseL = TRUE
)
}
\arguments{
\item{dirC}{Character: directory containing the 3 .tsv files}

\item{namePatternC}{Character: optional file name pattern common to all three
file names (e.g., when you want to distinguish between two sets of files
within the same directory)}

\item{fileTableNamesVc}{Vector of characters: if your file names do not
contain the standard 'dataMatrix', 'sampleMetadata', and 'variableMetadata'
patterns (e.g. if you use 'profile', 'observation', and 'feature' instead),
please indicate them here}

\item{outputC}{character(1): either 'exp' for SummarizedExperiment (default) or 'set' for ExpressionSet output format}

\item{verboseL}{Logical: should comments be printed?}
}
\value{
ExpressionSet instance
}
\description{
Creating a ExpressionSet object from the 3 'dataMatrix.tsv',
'sampleMetadata.tsv' and 'variableMetadata.tsv' tabulated files
}
\examples{
sacSet <- fromW4M(file.path(path.package("ropls"), "extdata"))
}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
