% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signalCalibrate.R
\name{signalCalibrate}
\alias{signalCalibrate}
\title{Quantification Filtering And Calibration}
\usage{
signalCalibrate(quantData, condInfo, repInfo, evaluationFeature,
  calibrationFeature, unitReference, unitCutoff = 0,
  calibrationFeature2 = NULL, fixMedian = 4.776)
}
\arguments{
\item{quantData}{A list of quantification matrices each with rows by
features (transcripts, genes, junctions or exons) and columns
by samples. Names of the list should be provided. The sizes of each
element should be the same. Missing data will be set to 0.}

\item{condInfo}{A factor documenting condition information of samples,
corresponding to the columns of each element in \code{quantData}.}

\item{repInfo}{A factor documenting replicate information of samples,
corresponding to the columns of each element in \code{quantData}.}

\item{evaluationFeature}{A logical vector corresponding to the
rows of each element in \code{quantData}, providing which features
should be considered for downstream evaluation, e.g. protein coding
genes.}

\item{calibrationFeature}{A logical vector corresponding to the
rows of each element in \code{quantData}, providing which features
should be
considered as calibration reference, e.g. house keeping genes.}

\item{unitReference}{A numeric number specifying which pipeline will
be selected as reference pipeline, i.e. the index of
one element in \code{quantData}.}

\item{unitCutoff}{A numeric number for signal cutoff on reference
pipeline specified by \code{unitReference} (default: 0).
Equivalent effects of cutoffs will be applied to other pipelines
accordingly.}

\item{calibrationFeature2}{A logical vector corresponding to the
rows of each element in \code{quantData}, providing which features
should be considered as references for calibration across
different datasets. Default \code{NULL} means no calibration needed.}

\item{fixMedian}{A numeric number specifying the median of detrend
logsignals for features specified by \code{calibrationFeature2}.
When comparing across datasets, those features will be calibrated to
have the same median as \code{fixMedian}, while other features
calibrated accordingly. The default is 4.776, which was calculated
based on one ENCODE dataset used in our web tool.}
}
\value{
A \code{rnaseqcomp} S4 class object
\item{quantData}{A filtered and calibrated list of quantifications
for downstream analysis.}
\item{condInfo}{A factor documenting sample condition information.}
\item{repInfo}{A factor documenting sample replicate information.}
\item{refMed}{A list of numeric vectors giving the log scale medians
of calibration features in different pipelines.}
\item{scaler}{A number that was used for scaling quantifications onto
reference pipeline.}
}
\description{
This is the function to do any pre-filtering or
pre-processing analysis for downstream benchmark estimation
and visualization. Pre-filtering includes row selection (e.g.
protein coding genes) of quantification table; pre-processing
includes calculation on a set of rows as calibration reference
(e.g. house keeping genes) across different quantification
pipelines, calibration of quantifications across all the
pipelines based on given cutoffs from selected pipelines.
}
\details{
In the functions \code{plotSD} and \code{plot2TX}, detrended
signals with value 0 will be at the same level as value 1 for
giving pipeline by \code{unitReference}.
}
\examples{
data(simdata)
condInfo <- factor(simdata$samp$condition)
repInfo <- factor(simdata$samp$replicate)
evaluationFeature <- rep(TRUE, nrow(simdata$meta))
calibrationFeature <- simdata$meta$house & simdata$meta$chr == 'chr1'
unitReference <- 1
dat <- signalCalibrate(simdata$quant, condInfo, repInfo, evaluationFeature,
calibrationFeature, unitReference, calibrationFeature2 = calibrationFeature)
}
