% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNE.R
\name{plotNE}
\alias{plotNE}
\title{Estimate And Plot Express And Non-express Features}
\usage{
plotNE(dat, steps = seq(-0.5, 12, 0.5), Ks = 0:3,
  pchK = seq_along(Ks) - 1, plotcell = 1, ...)
}
\arguments{
\item{dat}{A \code{rnaseqcomp} S4 class object.}

\item{steps}{A numeric vector specifying log-scale cutoffs to be used
for calculation and plotting. (default: seq(-0.5, 12, 0.5))}

\item{Ks}{A numeric vector specifying which cutoffs to be highlighted
and to which the reported proportions to be corresponding.}

\item{pchK}{Plot styles of highlight points corresponding
to \code{Ks}. (default: seq_along(Ks) - 1)}

\item{plotcell}{1 or 2 indicating which cell line
will be plotted. If values other than 1 and 2, both cell
lines will be plotted.  This value won't affect estimation for both
cell lines. (default: 1)}

\item{...}{Parameters for base function \code{plot}.}
}
\value{
\item{plot}{NE plots of quantification pipelines for
selected cell line by \code{plotcell}.}
\item{NE}{A list of two matrices. The first matrix gives
the proportion of disagreement and the second matrix gives the
proportion of both replicates under (non-express)
correspoinding cutoff \code{Ks}. Values are based on average
of two cell lines.}
}
\description{
For each cell line, any compared two replicates
might have a portion of transcripts that express in one replicate
but not the other, depending on what cutoff is used to define
non-express. This function estimate and plot the proportion of
disagreement using multiple cutoffs. Average is used when multiple
two-replicate comparisons included.
}
\examples{
data(simdata)
condInfo <- factor(simdata$samp$condition)
repInfo <- factor(simdata$samp$replicate)
evaluationFeature <- rep(TRUE, nrow(simdata$meta))
calibrationFeature <- simdata$meta$house & simdata$meta$chr == 'chr1'
unitReference <- 1
dat <- signalCalibrate(simdata$quant, condInfo, repInfo, evaluationFeature,
calibrationFeature, unitReference, calibrationFeature2 = calibrationFeature)
plotNE(dat)
}
