% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizeSingleRegion.R
\name{SummarizeSingleRegion}
\alias{SummarizeSingleRegion}
\title{Summarizes RNA editing levels from multiple sites in a single region.}
\usage{
SummarizeSingleRegion(
  region_df,
  rnaEditMatrix,
  selectMethod = MedianSites,
  ...
)
}
\arguments{
\item{region_df}{A data frame with the input genomic region. Please make 
sure columns \code{seqnames}, \code{start}, and \code{end} are included in
the data frame.}

\item{rnaEditMatrix}{A matrix (or data frame) of RNA editing level values 
for individual sites, with row names as site IDs in the form of
"chrAA:XXXXXXXX", and column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}

\item{selectMethod}{Method for summarizing regions. Available options are 
\code{"MaxSites", "MeanSites", "MedianSites", "PC1Sites"}. Please see
\code{\link{RegionSummaryMethod}} for more details.}

\item{...}{Dots for additional internal arguments (currently unused).}
}
\value{
A named numeric vector of summarized RNA editing levels with sample
  IDs as column names.
}
\description{
Summarizes RNA editing levels from multiple sites in an input
  region.
}
\examples{
  data(rnaedit_df)
  
  exm_region <- data.frame(
    seqnames = "chr1",
    start =  28691093,
    end = 28826881, 
    stringsAsFactors = FALSE
  )
   
  SummarizeSingleRegion(
    region_df = exm_region,
    rnaEditMatrix = rnaedit_df
  )[1:3]

}
\keyword{internal}
