% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_GetSitesLocations.R
\name{GetSitesLocations}
\alias{GetSitesLocations}
\title{Extract RNA editing sites located in a genomic region.}
\usage{
GetSitesLocations(
  region_df,
  rnaEditMatrix,
  output = c("locationsOnly", "locationsAndValues")
)
}
\arguments{
\item{region_df}{A data frame with the input genomic region. Please make 
sure columns \code{seqnames}, \code{start}, and \code{end} are included in 
the data frame.}

\item{rnaEditMatrix}{A matrix (or data frame) of RNA editing level values on
individual sites, with row names as site IDs in the form of
"chrAA:XXXXXXXX", and column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}

\item{output}{Type of output data. Defaults to \code{"locationsOnly"}.}
}
\value{
When \code{output} is set to \code{"locationsOnly"}, a data frame of 
  extracted and ordered RNA editing sites with columns \code{chr} and 
  \code{pos} will be returned. 
  
  When \code{output} is set to \code{"locationsAndValues"}, a data frame of
  RNA editing level values from the extracted and ordered sites will be
  returned. Please note that site IDs will be in row names of the output
  data frame.
}
\description{
Extract and order RNA editing sites located within an input 
  genomic region.
}
\examples{
  data (rnaedit_df)
  
  exm_region <- data.frame(
     seqnames = "chr1",
     start =  28000000,
     end = 28826881, 
     stringsAsFactors = FALSE
  )
  
  GetSitesLocations(
     region_df = exm_region,
     rnaEditMatrix = rnaedit_df,
     output = "locationsOnly"
  )[1:3, ]
   
}
\keyword{internal}
