% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotateResults.R
\name{AnnotateResults}
\alias{AnnotateResults}
\title{Add Annotations to site-specific or region-based analysis results.}
\usage{
AnnotateResults(
  results_df,
  closeByRegions_gr = NULL,
  inputRegions_gr = NULL,
  genome = c("hg38", "hg19"),
  analysis = c("region-based", "site-specific")
)
}
\arguments{
\item{results_df}{An output data frame from function 
\code{TestAssociations}, which includes variables for locations and result
of statistical tests for the genomic sites or regions.}

\item{closeByRegions_gr}{An output GRanges object from function
\code{AllCloseByRegions}, defaults to \code{NULL}.}

\item{inputRegions_gr}{A GRanges object for input genomic
regions, defaults to \code{NULL}.}

\item{genome}{Use \code{"hg19"} or \code{"hg38"} gene reference. Defaults 
to \code{"hg38"}.}

\item{analysis}{Results type. Defaults to \code{"region-based"}. When it's
set to \code{"site-specific"}, arguments \code{closeByRegions_gr} and 
\code{inputRegions_gr} will not be used and set to NULL automatically.}
}
\value{
A data frame with locations of the genomic sites or regions
  (\code{seqnames, start, end, width}), annotations for locations
  (\code{inputRegion, closeByRegion, symbol}), test statistics
  (\code{estimate, stdErr} or \code{coef, exp_coef, se_coef}), \code{pValue}
  and false discovery rate (\code{fdr}).
}
\description{
Add annotations to site-specific or region-based analysis 
  results from function \code{\link{TestAssociations}}.
}
\examples{
  data(rnaedit_df)
  
  # get GRanges for genes
  genes_gr <- TransformToGR(
    genes_char = c("PHACTR4", "CCR5", "METTL7A"),
    type = "symbol",
    genome = "hg19"
  )
  
  # find close-by regions within the genes
  closebyRegions_gr <- AllCloseByRegions(
    regions_gr = genes_gr,
    rnaEditMatrix = rnaedit_df
  )
  
  # identify co-edited regions within the genes 
  coedited_gr <- AllCoeditedRegions(
    regions_gr = closebyRegions_gr,
    rnaEditMatrix = rnaedit_df,
    output = "GRanges",
    method = "spearman"
  )
  
  # summarize editing levels within each gene by maximum
  summarizedRegions_df <- SummarizeAllRegions(
    regions_gr = coedited_gr,
    rnaEditMatrix = rnaedit_df,
    selectMethod = MaxSites
  )
  
  exm_pheno <- readRDS(
    system.file(
    "extdata",
    "pheno_df.RDS",
    package = 'rnaEditr',
    mustWork = TRUE
    )
  )
  
  # test summarized editing levels against survival outcome
  results_df <- TestAssociations(
    rnaEdit_df = summarizedRegions_df,
    pheno_df = exm_pheno,
    responses_char = "sample_type",
    covariates_char = NULL,
    respType = "binary"
  )
  
  AnnotateResults(
    results_df = results_df,
    closeByRegions_gr = closebyRegions_gr,
    inputRegions_gr = genes_gr,
    genome = "hg19"
  )
  
}
\seealso{
\code{\link{TransformToGR}}, \code{\link{AllCloseByRegions}}, 
  \code{\link{AllCoeditedRegions}}, \code{\link{CreateEditingTable}},
  \code{\link{SummarizeAllRegions}}, \code{\link{TestAssociations}}
}
