% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normByRUVs.R
\name{normByRUVs}
\alias{normByRUVs}
\title{Normalization by RUVSeq}
\usage{
normByRUVs(counts, RPFgroup, mRNAgroup = RPFgroup, k = 1)
}
\arguments{
\item{counts}{Output of \link{countReads}}

\item{RPFgroup, mRNAgroup}{Groups for RPF and mRNA files}

\item{k}{The number of factor of unwanted variation to be estimated from
the data. See \link[RUVSeq:RUVs]{RUVs}}
}
\value{
Normalized counts list
}
\description{
Normalization by RUVSeq:RUVs methods
}
\examples{
\dontrun{##waiting for EDASeq fix the issue.
path <- system.file("extdata", package="ribosomeProfilingQC")
#RPFs <- dir(path, "RPF.*?.[12].bam$", full.names=TRUE)
#RNAs <- dir(path, "mRNA.*?.[12].bam$", full.names=TRUE)
#gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
#cnts <- countReads(RPFs, RNAs, gtf, level="gene")
cnts <- readRDS(file.path(path, "cnts.rds"))
gp <- c("KD1", "KD1", "WT", "WT")
norm <- normByRUVs(cnts, gp, gp)
}

}
