% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{rename_transcripts}
\alias{rename_transcripts}
\title{Renames the transcripts}
\usage{
rename_transcripts(ribo, rename)
}
\arguments{
\item{ribo}{a path to the ribo file or a 'Ribo' object}

\item{rename}{A function that renames the original transcript or an already generated
character vector of aliases}
}
\value{
A character vector denoting the renamed transcript aliases
}
\description{
The function \code{\link{rename_transcripts}} strives to make the transcript names less
cumbersome to write and easier to use.
}
\details{
Transcript names found in a .ribo file can often be long and inconvenient to use.
As a result, this function allows the user to rename the transcripts.

Often times, a short function can be used on the ribo file reference names
to split and extract a more convenient name, and a function with a similar input and
output to {\code{\link{rename_default}}} can be passed in.

However, if there is no simple function that takes the original name and renames it into
a unique alias, then the user can provide a character vector of the same length as the number of
transcripts in the ribo file. This character vector would provide aliases that match the order
of the original reference names returned by the {\code{\link{get_reference_names}}} function.
}
\examples{
file.path <- system.file("extdata", "HEK293_ingolia.ribo", package = "ribor")
sample <- Ribo(file.path, rename = rename_default)

aliases <- rename_transcripts(sample, rename = rename_default)
}
\seealso{
{\code{\link{rename_default}}} to view expected input and output of a 'rename' function
{\code{\link{Ribo}}} to generate a ribo object
}
