% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_count_functions.R
\name{plot_region_counts}
\alias{plot_region_counts}
\title{Plots the region counts of UTR5, CDS, and UTR3}
\usage{
plot_region_counts(
  x,
  experiment,
  range.lower,
  range.upper,
  title = "Region Counts"
)
}
\arguments{
\item{x}{A 'Ribo' object or a DataFrame generated from \code{\link{get_region_counts}}}

\item{experiment}{a list of experiment names}

\item{range.lower}{a lower bounds for a read length range}

\item{range.upper}{an upper bounds for a read length range}

\item{title}{a title for the generated plot}
}
\value{
A 'ggplot' of the region counts for each of the experiments
}
\description{
The function \code{\link{plot_region_counts}} can take either a DataFrame
or a "Ribo" object to generate the a stacked bar plot of proportions that
correspond to the "UTR5", "CDS", and "UTR3" regions.
}
\details{
When given a 'Ribo' object, \code{\link{plot_region_counts}} calls
\code{\link{get_region_counts}} to retrieve the necessary information
for plotting. This option is in the case that a DataFrame of the
region count information is not required.

The user can instead provide a DataFrame with the same structure as the
output of the \code{\link{get_region_counts}} function where the 'transcript'
and 'length' parameters are the default values of TRUE. This also means that
the remaining parameters of the \code{\link{plot_region_counts}} function are not necessary.
The run time becomes substantially faster when \code{\link{plot_region_counts}} is given
the direct DataFrame to plot. However, the DataFrame needs to follow the format and 
types in the output of the reading functions
}
\examples{
#ribo object use case
#generate the ribo object
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#specify the regions and experiments of interest
regions <- c("UTR5", "CDS", "UTR3")
experiments <- c("Hela_1", "Hela_2", "WT_1")

plot_region_counts(sample,
                   range.lower = 2,
                   range.upper = 5,
                   experiments)

#DataFrame use case
#obtains the region counts at each individual read length, summed across every transcript
region.counts <- get_region_counts(sample,
                                   region = regions,
                                   range.lower = 2,
                                   range.upper = 5,
                                   tidy = TRUE,
                                   length = TRUE,
                                   transcript = TRUE)

#the params 'length' and 'transcript' must be set to true to use a DataFrame
plot_region_counts(region.counts)

}
\seealso{
\code{\link{get_region_counts}} to generate a DataFrame that can be provided as input,
\code{\link{Ribo}} to create a ribo.object that can be provided as input
}
