% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_functions.R
\name{get_info}
\alias{get_info}
\title{Get information about the .ribo file}
\usage{
get_info(ribo.object)
}
\arguments{
\item{ribo.object}{ribo.object is an S4 object of class "Ribo"}
}
\value{
Returns a list containing a nested list of file attributes, a logical
value denoting whether the root file has additional metadata, and a
data.frame of information on each experiment
}
\description{
The function \code{\link{get_info}} provides information on the attributes, metadata,
and datasets of the ribo file.
}
\details{
The \code{\link{get_info}} first provides information on the format version, left_span, right_span,
longest read length, shortest read length, metagene_radius, and reference model. The last element of the
returned list contains the information about the presence of coverage and RNA-seq data which are
optional datasets to include in a .ribo file.
}
\examples{
#generate the ribo object
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#retrieve information
get_info(sample)

}
\seealso{
\code{\link{Ribo}} to generate the necessary ribo.object parameter
}
