% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dna_objects.R
\name{plot_dna_objects}
\alias{plot_dna_objects}
\title{Plot annotation elements within genomic region}
\usage{
plot_dna_objects(
  regulondb,
  genome = "eschColi_K12",
  grange = GRanges("chr", IRanges(1, 5000)),
  elements = "gene"
)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{genome}{A valid UCSC genome name.}

\item{grange}{A \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges-class()}} object indicating position
left and right.}

\item{elements}{A character vector specifying which annotation elements to
plot. It can be any from: \code{"-10 promoter box"}, \code{"-35 promoter box"},
\code{"gene"}, \code{"promoter"}, \code{"Regulatory Interaction"}, \code{"sRNA interaction"},
or \code{"terminator"}.}
}
\value{
A plot with genomic elements found within a genome region,
including genes and regulators.
}
\description{
Plot annotation elements within genomic region
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) {
      regulondb_conn <- connect_database()
  }

## Build the regulondb object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "chr",
        database_version = "1",
        genome_version = "1"
    )

## Plot some genes from E. coli using default parameters
plot_dna_objects(e_coli_regulondb)

## Plot genes providing Genomic Ranges
grange <- GenomicRanges::GRanges(
    "chr",
    IRanges::IRanges(5000, 10000)
)
plot_dna_objects(e_coli_regulondb, grange)

## Plot aditional elements within genomic positions
plot_dna_objects(e_coli_regulondb,
    grange,
    elements = c("gene", "promoter")
)
}
\author{
Joselyn Chavez
}
