% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permTest.R
\name{permTest}
\alias{permTest}
\title{Permutation Test}
\usage{
permTest(A, ntimes=100, randomize.function, evaluate.function, alternative="auto", min.parallel=1000, force.parallel=NULL, randomize.function.name=NULL, evaluate.function.name=NULL, verbose=FALSE, ...)
}
\arguments{
\item{A}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{ntimes}{number of permutations}

\item{randomize.function}{function to create random regions. It must return a set of regions.}

\item{evaluate.function}{function to search for association. It must return a numeric value.}

\item{alternative}{the alternative hypothesis must be one of \code{"greater"}, \code{"less"} or \code{"auto"}. If \code{"auto"}, the alternative will be decided depending on the data.}

\item{min.parallel}{if force.parallel is not specified, this will be used to determine the threshold for parallel computation. If \code{length(A) * ntimes > min.parallel}, it will activate the parallel computation. Single threaded otherwise.}

\item{force.parallel}{logical indicating if the computation must be paralelized.}

\item{randomize.function.name}{character. If specified, the permTestResults object will have this name instead of the name of the randomization function used. Useful specially when using unnamed anonymous functions.}

\item{evaluate.function.name}{character. If specified, the permTestResults object will have this name instead of the name of the evaluation function used. Useful specially when using unnamed anonymous functions.}

\item{verbose}{a boolean. If verbose=TRUE it creates a progress bar to show the computation progress. When combined with parallel computation, it might have an impact in the total computation time.}

\item{...}{further arguments to be passed to other methods.}
}
\value{
A list of class \code{permTestResults} containing the following components:
\itemize{
\item \bold{\code{pval}} the p-value of the test.
\item \bold{\code{ntimes}} the number of permutations.
\item \bold{\code{alternative}} a character string describing the alternative hypotesis.
\item \bold{\code{observed}} the value of the statistic for the original data set.
\item \bold{\code{permuted}} the values of the statistic for each permuted data set.
\item \bold{\code{zscore}} the value of the standard score. \code{(observed-\link{mean}(permuted))/\link{sd}(permuted)}
\item \bold{\code{randomize.function}} the randomization function used.
\item \bold{\code{randomize.function.name}} the name of the randomization used.
\item \bold{\code{evaluate.function}} the evaluation function used.
\item \bold{\code{evaluate.function.name}} the name of the evaluation function used.
}
}
\description{
Performs a permutation test to see if there is an association between a region set and some other feature using
an evaluation function.
}
\details{
permTest performs a permutation test of the regions in RS to test the association with the feature evaluated with the evaluation function.
The regions are randomized using the randomization.function and the evaluation.function is used to evaluate them. More information can be found in
 the vignette.
}
\examples{
genome <- filterChromosomes(getGenome("hg19"), keep.chr="chr1")
A <- createRandomRegions(nregions=20, length.mean=10000000, length.sd=20000, genome=genome, non.overlapping=FALSE) 
B <- c(A, createRandomRegions(nregions=10, length.mean=10000, length.sd=20000, genome=genome, non.overlapping=FALSE))

 
pt2 <- permTest(A=A, B=B, ntimes=10, alternative="auto", verbose=TRUE, genome=genome, evaluate.function=meanDistance, randomize.function=randomizeRegions, non.overlapping=FALSE)
summary(pt2)
plot(pt2)
plot(pt2, plotType="Tailed")

}
\references{
Davison, A. C. and Hinkley, D. V. (1997) Bootstrap methods and their application, Cambridge University Press, United Kingdom, 156-160
}
\seealso{
\code{\link{overlapPermTest}}
}
