% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hub.R
\name{create_hub}
\alias{create_hub}
\title{Create UCSC track hub for BigWig files}
\usage{
create_hub(
  x,
  output_dir = file.path(tempdir(), x$project[1]),
  hub_name = "recount3",
  email = "someone@somewhere",
  show_max = 5,
  hub_short_label = "recount3 coverage",
  hub_long_label =
    "recount3 summaries and queries for large-scaleRNA-seq expression and splicing",
  hub_description_url = "https://rna.recount.bio/index.html",
  recount3_url = getOption("recount3_url", "http://duffel.rail.bio/recount3")
)
}
\arguments{
\item{x}{A \code{data.frame} created with \code{available_samples()} that has typically
been subset to a specific project ID from a given organism.}

\item{output_dir}{A \code{character(1)} with the output directory.}

\item{hub_name}{A \code{character(1)} with the UCSC track hub name you want
to display.}

\item{email}{A \code{character(1)} with the email used for the UCSC track hub.}

\item{show_max}{An \code{integer(1)} with the number of BigWig tracks to show
by default in the UCSC track hub. We recommend a single digit number.}

\item{hub_short_label}{A \code{character(1)} with the UCSC track hub short
label.}

\item{hub_long_label}{A \code{character(1)} with the UCSC track hub long label.}

\item{hub_description_url}{A \code{character(1)} with the URL to an \code{html} file
that will describe the UCSC track hub to users.}

\item{recount3_url}{A \code{character(1)} specifying the home URL for \code{recount3}
or a local directory where you have mirrored \code{recount3}. Defaults to the
load balancer \url{http://duffel.rail.bio/recount3}, but can also be
\url{https://recount-opendata.s3.amazonaws.com/recount3/release} from
\url{https://registry.opendata.aws/recount/} or from
IDIES at JHU \url{https://idies.jhu.edu/recount3/data} (which redirects to
\url{https://data.idies.jhu.edu/recount3/data/}). You can
set the R option \code{recount3_url} (for example in your \code{.Rprofile}) if
you have a favorite mirror.}
}
\value{
A directory at \code{output_dir} with the files needed for a UCSC
track hub.
}
\description{
This function creates a directory with the configuration files required for
creating a UCSC track hub for the BigWig files from a given project. These
files can then be hosted on GitHub or elsewhere. For more details about
UCSC track hubs, check
\url{https://genome.ucsc.edu/goldenpath/help/hgTrackHubHelp.html}.
}
\details{
See
\url{https://github.com/LieberInstitute/recount3-docs/blob/master/UCSC_hubs/create_hubs.R}
for an example of how this function was used.
}
\examples{

## Find all the mouse samples available from recount3
mouse_samples <- available_samples("mouse")

## Subset to project DRP001299
info_DRP001299 <- subset(mouse_samples, project == "DRP001299")

hub_dir <- create_hub(info_DRP001299)

## List the files created by create_hub()
hub_files <- list.files(hub_dir, full.names = TRUE, recursive = TRUE)
hub_files

## Check the files contents
sapply(hub_files, function(x) {
    cat(paste(readLines(x), collapse = "\n"))
})

## You can also check the file contents for this example project at
## https://github.com/LieberInstitute/recount3-docs/tree/master/UCSC_hubs/mouse/sra_DRP001299
## or test it out on UCSC directly through the following URL:
## https://genome.ucsc.edu/cgi-bin/hgTracks?db=mm10&lastVirtModeType=default&lastVirtModeExtraState=&virtModeType=default&virtMode=0&nonVirtPosition=&position=chr1&hubUrl=https://raw.githubusercontent.com/LieberInstitute/recount3-docs/master/UCSC_hubs/mouse/sra_DRP001299/hub.txt
}
