% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectCorrelatedRowsFromMatrices.R
\name{selectCorrelatedRowsFromMatrices}
\alias{selectCorrelatedRowsFromMatrices}
\title{Select features that are correlated with a given feature (or one or more features
from a set of features), merging results from multiple candidate feature matrices.}
\usage{
selectCorrelatedRowsFromMatrices(
  Y,
  XList,
  corThreshold = 0.1,
  useAbsCor = TRUE
)
}
\arguments{
\item{Y}{a vector or matrix; rows from each matrix element of X will be correlated with 
Y if Y is a vector or with rows of Y, if Y is a matrix.}

\item{XList}{a list of matrices whose rows will be correlated with Y (vector) or rows of Y (matrix).
The rownames in each matrix element of XList must be specified to values that are unique with
respect to the total set of rownames (as derived from all matrices in XList).}

\item{corThreshold}{the minimum correlation threshold for the row to be returned}

\item{useAbsCor}{a logical value indicating whether absolute correlations should be used
(default=TRUE).}
}
\value{
a matrix formed from rows of matrices in XList that are correlated with Y 
(if Y is a vector) or correlated with at least one row of Y if Y is a matrix or data frame.
}
\description{
Select features that are correlated with a given feature (or one or more features
from a set of features), merging results from multiple candidate feature matrices.
}
\examples{
vec <- runif(10)
names(vec) <- 1:10
matList <- list(X1 = matrix(runif(100), 10, 10), X2 = matrix(runif(100), 10, 10))
rownames(matList$X1) <- paste0("X1_row_", 1:10)
colnames(matList$X1) <- paste0("X1_col_", 1:10)
rownames(matList$X2) <- paste0("X2_row_", 1:10)
colnames(matList$X2) <- paste0("X2_col_", 1:10)
selectCorrelatedRowsFromMatrices(vec, matList)

}
\concept{rcellminer}
