% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellMiner.R
\name{plotCellMiner}
\alias{plotCellMiner}
\title{Description: Produces CellMiner-like plots in R}
\usage{
plotCellMiner(
  drugAct,
  molData,
  plots,
  nsc = NULL,
  gene = NULL,
  features = NULL,
  sub = NULL,
  xLimits = NULL,
  xLabel = NULL,
  extraPlot = NULL,
  verbose = FALSE
)
}
\arguments{
\item{drugAct}{a matrix of drug activity values (cell lines as columns, drug entries as rows)}

\item{molData}{a list of matricies a molecular}

\item{plots}{a vector of characters denoting the plots to include and the order (e.g. c("mut", "drug", "cop"). 
Currently, supported entries mutations (mut), drug activities (drug), copy number variations (cop)}

\item{nsc}{a string NSC ID that will be plotted when a "drug" entry appears in the plots vector}

\item{gene}{a string HUGO gene symbol for which the "mut", "cop", or "exp" plots will be produced if in plots vector}

\item{features}{a vector of strings that provide the full IDs for elements to be plotted (e.g. mutCDK4 for CDK4 mutations). 
This overwrites the nsc and gene parameters, but is needed in advanced plots that involve data that involves one-to-many 
relationships (e.g. many entries for a given gene in the exome data) and a gene symbol is ambiguous.}

\item{sub}{a vector of strings with sub-titles for each plot}

\item{xLimits}{a 2 number vector with the the minimum and maximum X-axis values (default: -3,3 for Z-scores, 0,1 for binary entries)}

\item{xLabel}{a string for the default X-axis label}

\item{extraPlot}{a list containing title, label, and values (numeric vector of length 60); only one extra plot can be included}

\item{verbose}{a boolean to show debugging information}
}
\value{
None
}
\description{
Description: Produces CellMiner-like plots in R
}
\examples{
drugAct <- exprs(getAct(rcellminerData::drugData))
molData <- getMolDataMatrices()
plots <- c("mut", "drug", "cop", "xai", "pro")
plotCellMiner(drugAct, molData, plots=plots, nsc="94600", gene="CDK4", verbose=FALSE)

plots <- c("mut", "xai", "cop", "cop", "cop", "cop")
plotCellMiner(drugAct, molData, plots=plots, nsc="94600", gene=c("CDK4", "TP53", 
  "BRAF", "GAPDH"), verbose=FALSE)

plotCellMiner(drugAct, molData, plots=NULL, nsc=NULL, features=c("mutCDK4", 
  "xaiCDK4", "exochr1:101704532_G_T", "mdaIS_P53_MUT", "mirhsa-miR-22", "proTP53_26_GBL00064"), 
  verbose=FALSE)

}
\author{
Augustin Luna <augustin AT mail.nih.gov>
}
\concept{rcellminer}
