% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRsd.R
\name{getRsd}
\alias{getRsd}
\title{Computes the relative standard deviation values with respect to the columns of a matrix or data.frame.}
\usage{
getRsd(dat, onlyReturnMedian = TRUE)
}
\arguments{
\item{dat}{a matrix or data.frame with numeric values.}

\item{onlyReturnMedian}{a logical value indicating whether only the median column RSD value should be returned (vs. all RSD values).}
}
\value{
median RSD value over the data set columns or all RSD values, depending on value of onlyReturnMedian (default=TRUE).
}
\description{
Computes the relative standard deviation values with respect to the columns of a matrix or data.frame.
}
\examples{
A <- matrix(rnorm(10*60), nrow=10)
getRsd(A)
getRsd(A, onlyReturnMedian=FALSE)

}
\concept{rcellminer}
