% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDrugActivityRange.R
\name{getDrugActivityRange}
\alias{getDrugActivityRange}
\title{Returns a vector of log activity range values for set of compounds.}
\usage{
getDrugActivityRange(nscSet, computeIQR = FALSE)
}
\arguments{
\item{nscSet}{a character vector specifying NSC identifier(s) for compound(s) of interest.}

\item{computeIQR}{logical value indicated whether inter-quartile range is to be computed;
otherwise absolute range is computed (default=FALSE).}
}
\value{
a numeric vector of NCI-60 log activity (-logGI50) range values indexed 
by the identifiers in nscSet.
}
\description{
Returns a vector of log activity range values for set of compounds.
}
\examples{
nscSet <- c("609699", "740")
getDrugActivityRange(nscSet)

}
\concept{rcellminer}
