% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getActivityRangeStats.R
\name{getActivityRangeStats}
\alias{getActivityRangeStats}
\title{Returns a table of activity range statistics for a set of compounds.}
\usage{
getActivityRangeStats(
  nscSet,
  concFormat = "NegLogGI50M",
  onlyCellMinerExps = TRUE
)
}
\arguments{
\item{nscSet}{a character vector specifying NSC identifier(s) for compound(s) of interest.}

\item{concFormat}{a string selected from "NegLogGI50M" or "IC50MicroM".
"NegLogGI50M" specifies activities as the negative log of the 50% growth
inhibitory concentration (molar). "IC50MicroM" specifies activities as the 50% growth 
inhibitory concentration (micromolar).}

\item{onlyCellMinerExps}{a logical value indicating whether to only return
experimental data included in CellMiner (default=TRUE).}
}
\value{
a table of activity range statistics for a set of compounds.
}
\description{
Returns a table of activity range statistics for a set of compounds.
}
\examples{
nscSet <- c("609699", "740")
getActivityRangeStats(nscSet)
getActivityRangeStats(nscSet, concFormat="IC50MicroM")

}
\concept{rcellminer}
