% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotMassDistribution}
\alias{plotMassDistribution}
\alias{PlotMassDistribution}
\title{Mass Distribution Plot}
\usage{
plotMassDistribution(x, method = "trellis")
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
plots the mass frequency in dependency to the charge state
}
\details{
displays charge state resolved frequency of precursor masses.
}
\examples{
rawrr::sampleFilePath() |> rawDiag::readRaw() |> rawDiag::plotMassDistribution('overlay')
}
\references{
\itemize{
\item rawDiag: \doi{10.1021/acs.jproteome.8b00173},
\item rawrr: \doi{10.1021/acs.jproteome.0c00866}
}
}
\author{
Christian Trachsel (2017), Christian Panse (2023)
}
