% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotChargeState}
\alias{plotChargeState}
\alias{PlotChargeState}
\title{Charge State Overview Plot}
\usage{
plotChargeState(x, method = "trellis")
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
graphs the number of occurrences of all selected precursor charge states.
}
\examples{
 rawrr::sampleFilePath() |> rawDiag::readRaw() -> S
 S |> rawDiag::plotLockMassCorrection()
}
\references{
\itemize{
\item rawDiag: \doi{10.1021/acs.jproteome.8b00173},
\item rawrr: \doi{10.1021/acs.jproteome.0c00866}
}
}
\author{
Christian Trachsel (2017), Christian Panse (2023)
}
